/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#ifndef __X_WND_GC_H_
#define __X_WND_GC_H_

#include <xdefs.h>
#include <xobject.h>

#define X_WND_GC(obj) ((XWndGC*) obj)

struct _XWndGC
{
  XObject       parent;

  XWndWindow*   window;
  xptr          native_gc;
};

XWndGC*
x_wnd_gc_new ();

xvoid
x_wnd_gc_destroy (XObject* self);

xvoid
x_wnd_gc_set_pencil (XWndGC* self, xuint size, xuint type);

xvoid
x_wnd_gc_set_fg_color (XWndGC* self, xushort red, xushort green, xushort blue);

xvoid
x_wnd_gc_set_bg_color (XWndGC* self, xushort red, xushort green, xushort blue);

xvoid
x_wnd_gc_set_pos (XWndGC* self, xint x, xint y);

xint
x_wnd_gc_get_pos_x (XWndGC* self);

xint
x_wnd_gc_get_pos_y (XWndGC* self);

xint
x_wnd_gc_get_text_width (XWndGC* self, xstr text);

xint
x_wnd_gc_get_text_height (XWndGC* self, xstr text);

xvoid
x_wnd_gc_draw_line (XWndGC* self, xint x1, xint y1, xint x2, xint y2);

xvoid
x_wnd_gc_draw_rectangle (XWndGC* self, xint x, xint y, xuint w, xuint h);

xvoid
x_wnd_gc_draw_ellipse (XWndGC* self, xint x, xint y, xuint w, xuint h);

xvoid
x_wnd_gc_draw_text (XWndGC* self, xint x, xint y, xstr text);

xvoid
x_wnd_gc_draw_image (XWndGC* self, xint x, xint y, xuint w, xuint h, XWndImage* img);

#endif
