/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <wnd/win32/xwnd-win32.h>
#include <xlist.h>

xvoid
x_wnd_event_win32_process_event (UINT Msg, HWND hWnd, WPARAM wParam, LPARAM lParam)
{
  XWndEvent*   evt;
  WINDOWPOS*   pWindowPos;

  evt = x_wnd_event_new ();
  evt->window = x_wnd_window_lookup ((xptr) hWnd);
  evt->message = XWND_EVENT_UNKNOWN;
  evt->x = 0;
  evt->y = 0;
  
  switch (Msg)
    {
    case WM_PAINT:
      evt->message = XWND_EVENT_WINDOW_PAINT;
      break;
    case WM_SIZE:
      evt->message = XWND_EVENT_WINDOW_SIZE;
      evt->w = (xint) LOWORD (lParam);
      evt->h = (xint) HIWORD (lParam);
      break;
    case WM_MOVE:
      evt->message = XWND_EVENT_WINDOW_MOVE;
      evt->x = (xint) LOWORD (lParam);
      evt->y = (xint) HIWORD (lParam);
      break;
    case WM_CLOSE:
      evt->message = XWND_EVENT_WINDOW_CLOSE;
      break;
    case WM_MOUSEMOVE:
      evt->message = XWND_EVENT_MOUSE_MOVE;
      evt->x = (xint) LOWORD (lParam);
      evt->y = (xint) HIWORD (lParam);
      break;
    case WM_LBUTTONDOWN:
      evt->message = XWND_EVENT_MOUSE_DOWN;
      evt->x = (xint) LOWORD (lParam);
      evt->y = (xint) HIWORD (lParam);
      break;
    case WM_LBUTTONUP:
      evt->message = XWND_EVENT_MOUSE_UP;
      evt->x = (xint) LOWORD (lParam);
      evt->y = (xint) HIWORD (lParam);
      break;
    }

  if (evt->message != XWND_EVENT_UNKNOWN)
    {
      if (g_wnd_event_callback)
	g_wnd_event_callback (evt);
    }
    
  x_unref (evt);
}

xptr
x_wnd_event_get ()
{
  XWndEvent* evt;
  MSG        msg;
  BOOL       ret;

  if (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE))
    {
      TranslateMessage (&msg);     
      DispatchMessage (&msg); 
    }
  
  return NULL;
}
