/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

/* CHANGES:
 *
 * - 06/03/2002 : HashTable support added by Xiong PuXiang (ffxz@gnuchina.org)
 */

#include <xlmain.h>
#include <xllang.h>
#include <xlbuiltin.h>
#include <cmdline.h>

#include <xapi/xalang.h>
#include <xapi/xasys.h>
#include <xapi/xaio.h>
#include <xapi/xanet.h>
#include <xapi/xascr.h>
#include <xapi/xawnd.h>

#include <cmdline.h>
#include <langc_yacc.h>

#include <malloc.h>
#include <errno.h>

XLMain* g_xl_main_global = NULL;

xvoid
xl_main_init ()
{
  g_xl_main_global = xl_main_new ();
}

xvoid
xl_main_exit ()
{
  x_unref (g_xl_main_global);
}

XLMain*
xl_main_new ()
{
  XLMain *self;

  self = x_new (XLMain);
  x_object_init_object (X_OBJECT (self), xl_main_destroy);

  self->debugger = FALSE;
  
  /* HashTable support (see above)
   */

  self->hash_local = NULL;
  self->hash_global = x_hash_table_new (x_string_hash, x_string_equal);
  self->hash_functions = x_hash_table_new (x_string_hash, x_string_equal);
  self->hash_classes = x_hash_table_new (x_string_hash, x_string_equal);

  self->list_stack = x_list_new ();
  
  return self;
}

xvoid
xl_main_destroy (XObject* self)
{
  x_unref (XL_MAIN (self)->list_stack);

  /* HashTable support (see above)
   */

  x_unref (XL_MAIN (self)->hash_global);
  x_unref (XL_MAIN (self)->hash_local);
  x_unref (XL_MAIN (self)->hash_functions);
  x_unref (XL_MAIN (self)->hash_classes);

  x_destroy (self);
}

xvoid
xl_main_add_fnct_builtin (XLMain* self, xstr p_name, XLFnctBuiltin p_builtin)
{
  XLFnct*	l_fnct;
  XString*	l_name;
  
  l_fnct = xl_fnct_new ();
  l_name = x_string_new ();

  x_string_set_str (l_name, p_name);
  xl_fnct_set_builtin (l_fnct, l_name, p_builtin);
  
  /* HashTable support (see above)
   */

  x_hash_table_insert(self->hash_functions, (void*)l_fnct->name, X_OBJECT(l_fnct));

  x_unref (l_fnct);
  x_unref (l_name);
}

XLFnct*
xl_main_add_fnct_native (XLMain* self, xstr p_name, xptr p_native)
{
  XLFnct*	l_fnct;
  XString*	l_name;
  
  l_fnct = xl_fnct_new ();
  l_name = x_string_new ();

  x_string_set_str (l_name, p_name);
  xl_fnct_set_native (l_fnct, l_name, p_native);

  /* HashTable support (see above)
   */

  x_hash_table_insert(self->hash_functions, (void*)l_fnct->name, X_OBJECT(l_fnct));

  x_unref (l_fnct);
  x_unref (l_name);

  return l_fnct;
}

XLFnct*
xl_main_add_fnct_expr (XLMain* self, xstr p_name, XLExpr* p_expr)
{
  XLFnct*	l_fnct;
  XString*	l_name;
  
  l_fnct = xl_fnct_new ();
  l_name = x_string_new ();

  x_string_set_str (l_name, p_name);
  xl_fnct_set_expr (l_fnct, l_name, p_expr);
  
  /* HashTable support (see above)
   */

  x_hash_table_insert (self->hash_functions, (void*) l_fnct->name, X_OBJECT(l_fnct));

  x_unref (l_fnct);
  x_unref (l_name);

  return l_fnct;
}

XLFnct*
xl_main_add_fnct_proto (XLMain* self, xstr p_name)
{
  XLFnct*	l_fnct;
  XString*	l_name;
  
  l_fnct = xl_fnct_new ();
  l_name = x_string_new ();

  x_string_set_str (l_name, p_name);
  xl_fnct_set_proto (l_fnct, l_name);
  
  /* HashTable support (see above)
   */

  x_hash_table_insert(self->hash_functions, (void*) l_fnct->name, X_OBJECT(l_fnct));

  x_unref (l_fnct);
  x_unref (l_name);

  return l_fnct;
}

XLFnct*
xl_main_get_fnct (XLMain* self, XString* p_name)
{
  /* HashTable support (see above)
   */

  return x_hash_table_find (self->hash_functions, (void*) p_name);
}

xvoid
xl_main_add_var (XLMain* self, XLVar* p_var, xbool p_global)
{
  /* HashTable support (see above)
   */

  if ((self->hash_local) && !p_global)
    x_hash_table_insert (self->hash_local, (xvoid*) p_var->name, X_OBJECT(p_var));
  else
    x_hash_table_insert (self->hash_global, (xvoid*) p_var->name, X_OBJECT(p_var));
}

XLVar*
xl_main_get_var (XLMain* self, XString* p_name)
{
  /* HashTable support (see above)
   */

  XLVar* l_var;

  if (self->hash_local) 
    {
      l_var = x_hash_table_find (self->hash_local, p_name);
      if (l_var)
	return l_var;
    }

  return x_hash_table_find (self->hash_global, p_name);
}

xvoid
xl_main_add_class (XLMain* self, XLClass* p_class)
{
  /* HashTable support (see above)
   */

  x_hash_table_insert (self->hash_classes, (xvoid*) p_class->name, X_OBJECT(p_class));
}

XLClass*
xl_main_get_class (XLMain* self, XString* p_name)
{
  /* HashTable support (see above)
   */

  return x_hash_table_find (self->hash_classes, p_name);
}

XHashTable*
xl_main_fnct_enter (XLMain* self, XLFnct* p_fnct)
{
  /* HashTable support (see above)
   */

  XHashTable* l_hash;
  
  l_hash = self->hash_local;
  self->hash_local = x_hash_table_new (x_string_hash, x_string_equal);
  
  return l_hash;
}

xvoid
xl_main_fnct_leave (XLMain* self, XHashTable* p_hash)
{
  /* HashTable support (see above)
   */

  x_unref (self->hash_local);
  self->hash_local = p_hash;
}

xvoid
xl_main_print (XString* p_msg)
{
}

int
xl_main_main (int argc, char** argv)
{
  struct gengetopt_args_info args_info;
  XLExpr*      l_root;
  XLExpr*      l_expr;
  XLFnct*      l_fnct;
  XString*     l_filename;
  XString*     l_package_name;
  XString*     l_name;
  XLLang*      l_lang;
  xuint        l_size;
  xuint        i;
  xuint        idx;
  xvoid        (*xmain) ();

  xl_main_init ();
  xl_builtin_init ();

  xa_lang_init ();
  xa_sys_init ();
  xa_io_init ();
  xa_net_init ();
  xa_scr_init ();
  xa_wnd_init ();

  /* Choose the right language from the file name
   * .xc = c
   * .xb = basic
   * .xl = lisp
   */

  if (cmdline_parser (argc, argv, &args_info) != 0)
    exit (1);

  if (args_info.debug_flag)
    g_xl_main_global->debugger = TRUE;
  else
    g_xl_main_global->debugger = FALSE;

  if (args_info.inputs_num == 0)
    {
      printf ("ERROR: Type 'xlang --help' for help\n");
      exit (1);
    }

  l_root = xl_expr_new ();
  xl_expr_set_block (l_root);

  l_filename = x_string_new ();
  for (i=0; i<args_info.inputs_num; i++)
    {
      l_lang = xl_lang_new (args_info.inputs[i]);
      if (!l_lang)
	{
	  printf ("ERROR: Invalid filename extension\n");
	  exit (-1);
	}

      x_string_set_str (l_filename, args_info.inputs[i]);
      l_expr = (*(l_lang->load)) (l_lang, l_filename);
      x_unref (l_lang);

      xl_expr_add (l_root, l_expr);
      x_unref (l_expr);
    }

  if (l_root)
    {
      l_package_name = x_string_new ();
      x_string_set_str (l_package_name, args_info.build_package_arg);

      if (x_string_cmp_str (l_package_name, "") != 0)
	{
	  printf ("Building package '%s' ...\n", x_string_get_str (l_package_name));
	  xl_expr_save (l_root, l_package_name);
	  x_unref (l_root);
	}
      else
	{
	  xl_expr_evaluate (l_root);
	  x_unref (l_root);
	  
	  if (args_info.jit_flag)
	    {
	      /* HashTable support (see above)
	       */
	      
	      x_hash_table_foreach (g_xl_main_global->hash_functions, (UserFunc) xl_fnct_compile, NULL);
	    }
	  
	  l_name = x_string_new ();
	  x_string_set_str (l_name, "main");
	  l_fnct = xl_main_get_fnct (g_xl_main_global, l_name);
	  x_unref (l_name);
	  if (l_fnct)
	    {
	      if (args_info.jit_flag)
		{
		  xmain = (void (*)()) x_zone_get_ptr (l_fnct->native_code);
		  
		  printf ("Start the compiled program\n");
		  (*xmain) ();
		  printf ("End\n");
		}
	      else
		{
		  xl_fnct_call (l_fnct, NULL);
		}
	      x_unref (l_fnct);
	    }
	  else
	    {
	      printf ("Function 'main' not founded\n");
	    }
	}

      x_unref (l_package_name);
    }
 
  x_unref (l_filename);

  xl_builtin_exit ();
  xl_main_exit ();
    
  return 0;
}
