/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xlcompiler.h>
#include <xzone.h>
#include <xldata.h>
#include <xlexpr.h>
#include <xltype.h>

xvoid
xl_compiler_op_pushl (XZone* p_code, xuint p_data)
{
  /* pushl <data> */
  x_zone_add_byte (p_code, 0x68);
  x_zone_add_dword (p_code, p_data);
}

xvoid
xl_compiler_op_pushl_local (XZone* p_code, xuint p_offset)
{
  /* movl <data>, %eax */

  x_zone_add_byte (p_code, 0x8B);
  x_zone_add_byte (p_code, 0x45);
  x_zone_add_byte (p_code, (xuchar) (0x100 - 4 - p_offset));

  /* pushl %eax */

  x_zone_add_byte (p_code, 0x50);
}

xvoid
xl_compiler_op_clean_stack (XZone* p_code, xuchar p_value)
{
  /* addl <value>, %esp */

  x_zone_add_byte (p_code, 0x83);
  x_zone_add_byte (p_code, 0xC4);
  x_zone_add_byte (p_code, p_value);
}

xvoid
xl_compiler_op_call (XZone* p_code, xptr p_fnct)
{
  /* movl <fnct>, %ebx */
  x_zone_add_byte (p_code, 0xBB);
  x_zone_add_dword (p_code, (xuint) p_fnct);

  /* call *%ebx */
  x_zone_add_byte (p_code, 0xFF);
  x_zone_add_byte (p_code, 0xD3);
}
xvoid
xl_compiler_op_reserve_local (XZone* p_code, xuint p_size)
{
  /* subl <size>, %esp */
  x_zone_add_byte (p_code, 0x83);
  x_zone_add_byte (p_code, 0xEC);
  x_zone_add_byte (p_code, (xuchar) p_size);
}

xvoid
xl_compiler_op_assign (XZone* p_code, xuint p_offset, xuint p_value)
{
  /* movl <value>, -offset(%ebp) */

  x_zone_add_byte (p_code, 0xC7);
  x_zone_add_byte (p_code, 0x45);
  x_zone_add_byte (p_code, (xuchar) (0x100 - 4 - p_offset));
  x_zone_add_dword (p_code, p_value);
}

xvoid
xl_compiler_op_ret (XZone* p_code)
{
  /* ret */
  x_zone_add_byte (p_code, 0xC3);
}

xvoid
xl_compiler_op_enter (XZone* p_code)
{
  /* pushl %ebp */
  x_zone_add_byte (p_code, 0x55);

  /* movl %esp, %ebp */
  x_zone_add_byte (p_code, 0x89);
  x_zone_add_byte (p_code, 0xE5);

  /* pushl %ebx */
  x_zone_add_byte (p_code, 0x53);
}

xvoid
xl_compiler_op_leave (XZone* p_code)
{
  /* pop %ebx */
  x_zone_add_byte (p_code, 0x5B);

  /* movl %ebp, %esp */
  x_zone_add_byte (p_code, 0x89);
  x_zone_add_byte (p_code, 0xEC);

  /* popl %ebp */
  x_zone_add_byte (p_code, 0x5D);

  xl_compiler_op_ret (p_code);
}

xvoid
xl_compiler_compile_fnct_xlang (XLExpr* p_expr, XZone* p_code)
{
  XLExpr*  l_subexpr;
  xuint     l_nparams;
  xint     k;

  l_nparams = xl_expr_get_size (p_expr);
  for (k=l_nparams-1; k>=0; k--)
    {
      l_subexpr = xl_expr_get (p_expr, k);

      switch (l_subexpr->expr_type)
	{
	case XL_EXPR_TYPE_DATA:
	  xl_expr_evaluate (l_subexpr);
      
	  switch (l_subexpr->data->type->type)
	    {
	    case XL_TYPE_TYPE_STRING:
	      xl_compiler_op_pushl (p_code, x_access (l_subexpr->data->raw, 4, xuint));
	      break;
	    case XL_TYPE_TYPE_UINT:
	      xl_compiler_op_pushl (p_code, x_access (l_subexpr->data->raw, 0, xuint));
	      break;
	    }
	  break;
	case XL_EXPR_TYPE_IDENTIFIER:
	  xl_compiler_op_pushl_local (p_code, 0);
	  break;
	}
      
      x_unref (l_subexpr);
    }
  xl_compiler_op_call (p_code, printf);
  xl_compiler_op_clean_stack (p_code, l_nparams * 4);
}

xvoid
xl_compiler_compile_fnct (XLExpr* p_expr, XZone* p_code)
{
  XLExpr* l_expr;

  if (x_string_cmp_str (p_expr->identifier, "local") == 0)
    {
      xl_compiler_op_reserve_local (p_code, 4);
      return;
    }
  if (x_string_cmp_str (p_expr->identifier, "=") == 0)
    {
      l_expr = xl_expr_get (p_expr, 1);
      xl_expr_evaluate (l_expr);

      switch (l_expr->data->type->type)
	{
	case XL_TYPE_TYPE_STRING:
	  xl_compiler_op_assign (p_code, 0, x_access (l_expr->data->raw, 4, xuint));
	  break;
	case XL_TYPE_TYPE_UINT:
	  xl_compiler_op_assign (p_code, 0, x_access (l_expr->data->raw, 0, xuint));
	  break;
	}     

      x_unref (l_expr);
      return;
    }

  xl_compiler_compile_fnct_xlang (p_expr, p_code);
}

xvoid
xl_compiler_compile (XLExpr* p_expr, XZone* p_code)
{
  XString* l_string;
  XLExpr*  l_expr;
  FILE*    f;

  xuchar*     data;
  xuint     i;
  xuint     l_size;

  xl_compiler_op_enter (p_code);

  l_size = xl_expr_get_size (p_expr);
  for (i=0; i<l_size; i++)
    {
      l_expr = xl_expr_get (p_expr, i);

      switch (l_expr->expr_type)
	{
	case XL_EXPR_TYPE_FNCT:
	  xl_compiler_compile_fnct (l_expr, p_code);
	  break;
	default:
	  break;
	}

      x_unref (l_expr);
    }

  xl_compiler_op_leave (p_code);

  f = fopen ("dump.bin", "w+");
  fwrite (p_code->data, p_code->size, 1, f);
  fclose (f);
}






