/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xlbuiltin.h>
#include <xlclass.h>
#include <xlmain.h>
#include <xlmeth.h>

#include <xapi/xaapi.h>
#include <io/xio.h>
#include <io/xiofile.h>

xvoid
xa_io_init ()
{
  /* IO
   */

  xa_api_reg_fnct ("io_write", x_io_write, "void",
		   "string", "text",
		   NULL);

  xa_api_reg_fnct ("io_err_write", x_io_err_write, "void",
		   "string", "text",
		   NULL);

  xa_api_reg_fnct ("io_read", x_io_read, "void",
		   "string", "text",
		   "uint", "size",
		   NULL);

  /* IO File
   */

  xa_api_reg_const_uint ("IO_FILE_READ", X_IO_FILE_READ);
  xa_api_reg_const_uint ("IO_FILE_WRITE", X_IO_FILE_WRITE);
  xa_api_reg_const_uint ("IO_FILE_CREATE", X_IO_FILE_CREATE);

  xa_api_reg_fnct ("io_file_open", x_io_file_open, "int",
		   "string", "filename",
		   "uint", "mode",
		   NULL);

  xa_api_reg_fnct ("io_file_close", x_io_file_close, "void",
		   "int", "fileid",
		   NULL);

  xa_api_reg_fnct ("io_file_write", x_io_file_write, "void",
		   "int", "fileid",
		   "string", "text",
		   NULL);

  xa_api_reg_fnct ("io_file_read", x_io_file_read, "void",
		   "int", "fileid",
		   "string", "text",
		   "uint", "size",
		   NULL);

  xa_api_reg_fnct ("io_file_is_eof", x_io_file_is_eof, "bool",
		   "int", "fileid",
		   NULL);

  xa_api_reg_fnct ("io_file_get_pos", x_io_file_get_pos, "uint",
		   "int", "fileid",
		   NULL);

  xa_api_reg_fnct ("io_file_set_pos", x_io_file_set_pos, "uint",
		   "int", "fileid",
		   "uint", "pos",
		   NULL);

  xa_api_reg_fnct ("io_file_get_size", x_io_file_get_size, "uint",
		   "int", "fileid",
		   NULL);
}

xvoid
xa_io_exit ()
{
}
