/* Grizzly Studio - the eXtensible Language IDE
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

import "project_prop.xc";

const uint PROJECT_TYPE_NEW = 0;
const uint PROJECT_TYPE_OPEN = 1;

class GrizzlyProject
{
  uint             project_type;
  string           name;
  string           version;
  string           descr; 
  string           projects[];
  GrizzlyDocument  documents[];

  void open (string project_name)
    {
      xmlDocPtr  doc;
      xmlNodePtr tree;
      xmlNodePtr node_sources;
      xmlNodePtr node_doc;
      uint       i;

      name = project_name;

      arr_resize (documents, 0);

      doc = xmlParseFile (g_get_home_dir () + "/.grizzly/" + name + "/" + name + ".xml");
      tree = xmlDocGetRootElement (doc);

      node_sources = tree.children;
      node_doc = node_sources.children;
      while (node_doc != null)
	{	 
	  self.add_document (xmlGetProp (node_doc, "filename"));
	  node_doc = node_doc.next;
	}

      project_type = PROJECT_TYPE_OPEN;
    }
  
  void build_list ()
    {
      string        path;
      pointer       dp;
      dirent        ep;
      uint          idx;
      cstring       text;

      arr_resize (projects, 0);

      dp = sys_opendir (g_get_home_dir () + "/.grizzly/");
      ep = sys_readdir (dp);
      while (ep != null)
	{
	  text = addr_of (ep.d_name);

	  if ((strcmp (text, ".") != 0) && (strcmp (text, "..")))
	    {
	      idx = arr_getsize (projects);
	      arr_resize (projects, idx + 1);
	      projects[idx] = text;
	    }

	  ep = sys_readdir (dp);
	}

      sys_closedir (dp);
    }

  void choose ()
    {
      grizzly.project_choose_dialog.init ();
      grizzly.project_choose_dialog.show ();
    }

  void save ()
    {
      xmlDocPtr  doc;
      xmlNodePtr node_sources;
      xmlNodePtr node_doc;
      string     path;
      string     project_filename;
      uint       i;

      if (project_type == PROJECT_TYPE_NEW)
	{
	  if (self.is_exist (name))
	    {
	      io_write ("Project already exists\n");
	      return;
	    }
	  else
	    {
	      path = g_get_home_dir () + "/.grizzly/" + name;
	      sys_mkdir (path, 770);
	      sys_chdir (path);
	    }
	}

      doc = xmlNewDoc("1.0");
      doc.children = xmlNewDocNode (doc, null, "grizzly_project", null);
      xmlSetProp(doc.children, "name", name);
      xmlSetProp(doc.children, "descr", descr);
      xmlSetProp(doc.children, "version", version);

      node_sources = xmlNewChild(doc.children, null, "sources", null);

      for (i=0; i<arr_getsize (documents); i++)
	{
	  node_doc = xmlNewChild(node_sources, null, "source", null);
	  xmlSetProp (node_doc, "filename", documents[i].filename);
	}
      project_filename = g_get_home_dir () + "/.grizzly/" + name + "/" + name + ".xml";
      xmlSaveFile (project_filename, doc);
    }

  void add_document (string filename)
    {
      GrizzlyEditorSource editor;
      uint                i;

      i = arr_getsize (documents);
      arr_resize (documents, i + 1);

      documents[i].open (filename);
      editor.open (documents[i]);

      grizzly.fe.add_source (filename);
    }

  bool is_exist (string project_name)
    {
      string path;
      int   ret;

      path = g_get_home_dir () + "/.grizzly/" + project_name;
      if (sys_chdir (path) == 0)
	return true;
      else
	return false;
    }

  void ok ()
    {
      if (self.is_exist (name))
	{
	  io_write ("Alread exists\n"); 
	}
      else 
	{
	}
    }

  void new ()
    {
      project_type = PROJECT_TYPE_NEW;
      grizzly.project_dialog.init ();
      grizzly.project_dialog.show ();
    }

  void show_properties ()
    {
      grizzly.project_dialog.init ();
      grizzly.project_dialog.load ();
      grizzly.project_dialog.show ();
    }
}

