/* Grizzly Studio - the eXtensible Language IDE
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

void grizzly_editor_source_changed (GtkWidget editor)
{
}

class GrizzlyEditorSource
{
  GtkWidget editor;

  void open (GrizzlyDocument document)
    {
      GtkWidget table;
      GtkWidget vscrollbar;
      GtkWidget hscrollbar;

      editor = gtk_text_new (null, null);

      table = gtk_table_new (2, 2, false);

      gtk_table_set_row_spacing (table, 0, 2);
      gtk_table_set_col_spacing (table, 0, 2); 

      vscrollbar = gtk_vscrollbar_new (((GtkText) editor).vadj);
      hscrollbar = gtk_hscrollbar_new (((GtkText) editor).hadj);

      gtk_table_attach (table, editor, 0, 1, 0, 1,
			GTK_EXPAND | GTK_SHRINK | GTK_FILL, 
			GTK_EXPAND | GTK_SHRINK | GTK_FILL, 
			0, 0);

      gtk_table_attach (table, vscrollbar, 1, 2, 0, 1,
			GTK_FILL, 
			GTK_EXPAND | GTK_SHRINK | GTK_FILL,
			0, 0);
      
      gtk_table_attach (table, hscrollbar, 0, 1, 1, 2,
			GTK_EXPAND | GTK_SHRINK | GTK_FILL,
			GTK_FILL, 
			0, 0);

      gtk_notebook_append_page (grizzly.fe.document_view, table, gtk_label_new (document.filename));

      gtk_widget_show_all (table);

      gtk_text_set_editable (editor, true);
      gtk_text_insert (editor, 0, 0, 0, 
		       document.data, strlen(document.data));

      //self.syntax_color ();
    }

  uint syntax_process (string pattern, uint start, GdkColor color)
    {
      string   text;
      string   subtext;
      RegEx    regex;
      RegMatch regmatch;
      uint     ok;
      uint     oldpos;
      uint     status;
      uint     length;
      
      text = gtk_editable_get_chars (editor, start, -1);
      status = regcomp (addr_of (regex), pattern, REG_EXTENDED);

      ok = regexec (addr_of (regex), text, 1, addr_of (regmatch), 0);
      if (ok == 0)
	{
	  if ((start + regmatch.rm_so) >= strlen (text))
	    {
	      return -1;
	    }
	  else
	    {
	      subtext = gtk_editable_get_chars (editor, start + regmatch.rm_so, start + regmatch.rm_eo);
	      length = strlen (subtext);
	      if ((start + regmatch.rm_so + length) >= strlen (text))
		{
		  length = strlen (text) - start + regmatch.rm_so;
		}

	      gtk_editable_set_position (editor, start + regmatch.rm_so);
	      gtk_text_set_point (editor, start + regmatch.rm_so);
	      gtk_text_forward_delete (editor, length - 1);
	      gtk_text_insert (editor, 0, addr_of (color), 0, subtext, length);
	      
	      return (start + regmatch.rm_eo);
	    }
	}
      else
	{
	  return -1;
	}
    }
  
  void syntax_color ()
    {
      string text;
      uint   oldpos;
      uint   pos;
      uint   posx;
      string comment_pattern;
      string string_pattern;
      string type_pattern;
      string keyword_pattern;
      
      oldpos = gtk_editable_get_position (editor);
      text = gtk_editable_get_chars (editor, 0, -1);
  
      comment_pattern = "/\\*[^=]*\\*/";
      // comment_pattern = "/\\*[\\d\\D]*?\\*/";

      string_pattern = "\"[^\"]*\"";
      type_pattern = "uint|float|string|pointer|void";
      keyword_pattern = "import|while|if|\\+|==";
          
      gtk_text_freeze (editor);

      pos = self.syntax_process (type_pattern, 0, color_type);
      while (pos != -1)
	{
	  posx = pos;
	  pos = self.syntax_process (type_pattern, posx, color_type);
	}
     
      pos = self.syntax_process (keyword_pattern, 0, color_keyword);
      while (pos != -1)
	{
	  posx = pos;
	  pos = self.syntax_process (keyword_pattern, posx, color_keyword);
	}

      pos = self.syntax_process (string_pattern, 0, color_string);
      while (pos != -1)
	{
	  posx = pos;
	  pos = self.syntax_process (string_pattern, posx, color_string);
	}

      pos = self.syntax_process (comment_pattern, 0, color_comments);
      while (pos != -1)
	{
	  posx = pos;
	  pos = self.syntax_process (comment_pattern, posx, color_comments);
	}

      gtk_editable_set_position (editor, oldpos);
      gtk_text_thaw (editor);
    }
}
  
  
