/* X Language Library - The X Language Library
 * Copyright (C) 2002 Patrick Deschenes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */ 

class wndEntry 
inherit wndWidget
{
  string  text;

  void wndEntry ()
    {
      self.wndWidget ();     
    }

  void paint ()
    {
      wndGC  gc;
      uint   w;
      uint   h;
      uint   x;
      uint   y;

      w = self.getWidth ();
      h = self.getHeight ();

      gc = new wndGC;
      gc.acquire (self);

      gc.drawRectangle (0, 0, w, h);

      gc.setFGColor (96, 96, 96);
      gc.drawLine (0, 0, w, 0);
      gc.drawLine (0, 0, 0, h);
      gc.setFGColor (255, 255, 255);
      gc.drawLine (0, h, w, h);
      gc.drawLine (w, 0, w, h);

      gc.drawText ((w - gc.getTextWidth (text)) - 5,
		   (h - gc.getTextHeight (text)) / 2, text);
     
      gc.release (self);
    }

  void create (string entry_text, int x, int y, int w, int h)
    {
      self.text = entry_text;
      self.create_child (x, y, w, h);
    }

  void setText (string entry_text)
    {
      self.text = entry_text;
      self.redraw ();
    }

  string getText ()
    {
      return self.text;
    }
}
