/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xobject.h>

XObject*
x_object_new ()
{
  XObject* self;
  
  self = x_new (XObject);
  x_object_init_object (X_OBJECT (self), x_object_destroy);
  
  return self;
}

xvoid
x_object_destroy (XObject* self)
{
  x_destroy (self);
}

xvoid
x_object_init_object (XObject* self, XObjectDestroy p_destroy)
{
  self->refcount = 1;
  self->destroy = p_destroy;
}

XObject*
x_object_addref (XObject* self)
{
  if (!self) return NULL;

  self->refcount++;
  return self;
}

xvoid
x_object_unref (XObject* self)
{
  if (!self) return;

  self->refcount--;
  if (self->refcount <= 0)
    {
      (*self->destroy) (self);
    }
}
