/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xmem.h>

xuint obj_alloc = 0;

xptr
x_mem_new (xuint p_size)
{
  if (p_size)
    {
      obj_alloc++;
      return (xptr) calloc (1, p_size);
    }
  else
    return NULL;
}

xptr
x_mem_resize (xptr p_ptr, xuint p_size)
{
  if (p_ptr)
    return (xptr) realloc (p_ptr, p_size);
  else
    return x_mem_new (p_size);
}

xvoid
x_mem_destroy (xptr p_ptr)
{
  if (p_ptr)
    {
      obj_alloc--;
      free (p_ptr);
    }
}

xvoid
x_mem_copy (xptr p_src, xptr p_dst, xuint p_size)
{
  memcpy (p_dst, p_src, p_size);
}

xvoid
x_mem_debug ()
{
  printf ("unallocated objects = %d\n", obj_alloc);
}
