/* X Language - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#ifndef __XDEFS_H_
#define __XDEFS_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef TRUE
	#define TRUE -1
	#define FALSE 0
#endif

typedef signed char xchar;
typedef unsigned char xuchar;
typedef signed short xshort;
typedef unsigned short xushort;
typedef signed int xint;
typedef unsigned int xuint;
typedef float xfloat;
typedef double xdouble;
typedef int xbool;
typedef void xvoid;
typedef void *xptr;
typedef xchar *xstr;

#define x_alloc(size) ((xptr) x_mem_new (size))
#define x_new(type) (type*) x_mem_new (sizeof (type));
#define x_new_of_size(type, size) (type*) x_mem_new (sizeof (type) * size);
#define x_resize(obj, size) obj = x_mem_resize ((xptr) obj, size);
#define x_destroy(obj) x_mem_destroy ((xptr) obj);
#define x_access(ptr, offset, type) *((type*) (((xchar*) ptr) + offset))
#define x_addref(type, obj) (type*) x_object_addref (X_OBJECT (obj))
#define x_unref(obj) x_object_unref ((XObject*) obj)

int
free_mem ();


#define x_assert(expr) \
  { \
	if (!(expr)) \
  		printf ("file %s: line %d (%s): assertion failed: (%s)\n", \
	    __FILE__,	__LINE__, __PRETTY_FUNCTION__, #expr); \
  }

#define x_trace(msg) { printf ("(%s):%d: '%s'\n", __PRETTY_FUNCTION__, __LINE__, msg); }

#include <xmem.h>

#endif
