/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xltype.h>
#include <xlmain.h>

XLType*
xl_type_new (XLTypeType p_type, XLTypeArrayType p_array_type, xuint p_array_size, XString* p_classname)
{
  XLType *self;

  self = x_new (XLType);
  x_object_init_object (X_OBJECT (self), xl_type_destroy);

  self->type = p_type;
  self->array_type = p_array_type;
  self->array_size = p_array_size;
  self->classname = x_addref (XString, p_classname);
  self->class = NULL;
    
  return self;
}

xvoid
xl_type_destroy (XObject* self)
{
  x_unref (XL_TYPE (self)->class);
  x_unref (XL_TYPE (self)->classname);

  x_destroy (self);
}

xuint
xl_type_get_size (XLType* self)
{
  XLClass* l_class;

  if (self->type == XL_TYPE_TYPE_STRING)
    return sizeof (xuint) + sizeof (xptr);

  if (self->type == XL_TYPE_TYPE_STRING_NATIVE)
    return sizeof (xstr);
 
  if (self->type == XL_TYPE_TYPE_BOOL)
    return sizeof (xbool);
 
  if (self->type == XL_TYPE_TYPE_U32)
    return sizeof (xuint);

  if (self->type == XL_TYPE_TYPE_U16)
    return sizeof (xuint);

  if (self->type == XL_TYPE_TYPE_POINTER)
    return sizeof (xptr);

  if (self->type == XL_TYPE_TYPE_MAPPING)
    return sizeof (xptr);
   
  if (self->type == XL_TYPE_TYPE_STATIC || self->type == XL_TYPE_TYPE_DYNAMIC)
    {
      l_class = xl_type_get_class (self);
      return xl_class_get_size (l_class);
    }

  return 0;
}

XLClass*
xl_type_get_class (XLType* self)
{
  if (self->type == XL_TYPE_TYPE_STATIC || self->type == XL_TYPE_TYPE_DYNAMIC)
    {
      if (!self->class)
	{
	  self->class = xl_main_get_class (g_xl_main_global, self->classname);
	  if (self->class)
	    return self->class;
	  else
	    {
	      printf ("ERROR: Undefined class '%s'\n", x_string_get_str (self->classname));
	      exit (0);
	    }
	}
      else
	return self->class;
    }
  else
    return NULL;
}

xvoid
xl_type_init_data (XLType* self, XLData* p_data)
{
}

xbool
xl_type_validate (XLType* self, XLType* p_type)
{
  return FALSE;
}


























