/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#ifndef __XL_FNCT_H_
#define __XL_FNCT_H_

#include <xdefs.h>
#include <xobject.h>
#include <xstring.h>
#include <xzone.h>
#include <xltype.h>
#include <xlexpr.h>
#include <xlfield.h>

#define XL_FNCT(obj) ((XLFnct*) obj)

typedef enum {
	XL_FNCT_TYPE_NONE,
	XL_FNCT_TYPE_BUILTIN,
	XL_FNCT_TYPE_NATIVE,
	XL_FNCT_TYPE_EXPR
} XLFnctType;

typedef xvoid (*XLFnctBuiltin) (XLExpr* p_expr);
struct _XLFnct
{
  XObject parent;

  XString* 	name;
  XLFnctType  	type;
  XLType*	ret_type;
  XLExpr*	expr;
  XLFnctBuiltin	builtin;
  xptr		library;
  xptr		symbol;
  xptr          native;
  xbool         opt_param;
  xuchar        stub[20];
  XZone*        native_code;
  
  XList*	list_params;
};

extern XLData* g_xl_fnct_return;
extern xbool   g_xl_fnct_halt;

XLFnct*
xl_fnct_new ();

xvoid
xl_fnct_destroy (XObject* self);

xvoid
xl_fnct_set_builtin (XLFnct* self, XString* p_name, XLFnctBuiltin p_builtin);

xvoid
xl_fnct_set_native (XLFnct* self, XString* p_name, xptr p_native);

xvoid
xl_fnct_set_expr (XLFnct* self, XString* p_name, XLExpr* p_expr);

xptr
xl_fnct_get_ptr (XLFnct* self);

xvoid
xl_fnct_add_param (XLFnct* self, XLField* p_param);

xvoid
xl_fnct_call_init (XLFnct* self);

xvoid
xl_fnct_push (XLFnct* self, XLData* p_param);

XLData*
xl_fnct_call (XLFnct* self, XLExpr* p_expr);

xvoid
xl_fnct_compile (XLFnct* self);

#endif
