/* XLanguage - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

#include <xlclass.h>
#include <xlfield.h>
#include <xlmeth.h>

XLClass*
xl_class_new (XString* p_name, XLClassType p_type, xuint p_size)
{
  XLClass *self;
  
  self = x_new (XLClass);
  x_object_init_object (X_OBJECT (self), xl_class_destroy);

  self->type = p_type;

  switch (self->type)
    {
    case XL_CLASS_DEFAULT:
      self->size = 0;
      break;
    case XL_CLASS_BINDING_PTR:
      self->size = sizeof (xptr);
      break;
    case XL_CLASS_BINDING_STRUCT:
      self->size = p_size;
      break;
    default:
      self->size = 0;
      break;
    }
  self->name = x_addref (XString, p_name);
  self->parent_class = NULL;
  self->list_fields = x_list_new ();
  self->list_methods = x_list_new ();

  return self;
}

xvoid
xl_class_destroy (XObject* self)
{
  x_unref (XL_CLASS (self)->list_fields);
  x_unref (XL_CLASS (self)->list_methods);
  x_unref (XL_CLASS (self)->parent_class);
  x_unref (XL_CLASS (self)->name);

  x_destroy (self);
}

xvoid
xl_class_init_data (XLClass* self, XLData* p_data)
{
}

xuint
xl_class_get_size (XLClass* self)
{
  return self->size;
}

xvoid
xl_class_add_field (XLClass* self, XLField* p_field)
{
  p_field->index = self->size;
  self->size += xl_type_get_size (p_field->type);
  x_list_add (self->list_fields, X_OBJECT (p_field));
}

xvoid
xl_class_add_field_offset (XLClass* self, XLField* p_field, xuint p_offset)
{
  p_field->index = p_offset;
  x_list_add (self->list_fields, X_OBJECT (p_field));
}

XLField*
xl_class_get_field (XLClass* self, XString* p_name)
{
  XLField*	l_field;
  xuint		i, l_size;
	
  if (!self) return NULL;

  l_size = x_list_get_size (self->list_fields);
  
  for (i = 0; i < l_size; i++)
    {
      l_field = XL_FIELD (x_list_get (self->list_fields, i));
      if (x_string_cmp (p_name, l_field->name) == 0)
	return l_field;
       
      x_unref (l_field);
    }
  
  return NULL;
}

xvoid
xl_class_add_method (XLClass* self, XLMeth* p_method)
{
  x_list_add (self->list_methods, X_OBJECT (p_method));
}

XLMeth*
xl_class_get_method (XLClass* self, XString* p_name)
{
  XLMeth*	l_method;
  xuint		i, l_size;
	
  l_size = x_list_get_size (self->list_methods);
  
  /*  printf ("Search method '%s' in '%s'\n", x_string_get_str (p_name), x_string_get_str (self->name));*/
  for (i = 0; i < l_size; i++)
    {
      l_method = XL_METH (x_list_get (self->list_methods, i));
      /*      printf (" looking for '%s'\n", x_string_get_str (l_method->name)); */
      if (x_string_cmp (p_name, l_method->name) == 0)
	return l_method;
       
      x_unref (l_method);
    }
  
  return NULL;
}

