/* X/lang - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://xlang.sourceforge.net
 */

%{

#include <stdio.h>
#include <stdlib.h>

#include <xltype.h>
#include <xlexpr.h>

#include <xllang.h>
#include <langlisp_yacc.h>

xchar string_buf[10000];
xchar *string_buf_ptr;

%}

DIGIT		[0-9]
IDENTIFIER      [a-zA-Z_][a-zA-Z0-9_]*

%x comment
%x string

%%

";"[^\n]*[\n]        { g_lang_line++; }
global               { return GLOBAL; }
local                { return LOCAL; }
fnct                 { return FNCT; }
if                   { return IF; }
else                 { return ELSE; }
class                { return CLASS; }
void                 { return VOID; }
char                 { return CHAR; }
uchar                { return UCHAR; }
short                { return SHORT; }
ushort               { return USHORT; }
int                  { return INT; }
uint                 { return UINT; }
float                { return FLOAT; }
double               { return DOUBLE; }
string               { return STRING; }
pointer              { return POINTER; }
handle               { return POINTER; }
bool                 { return BOOL; }
return               { return RETURN; }
while                { return WHILE; }
dynamic              { return DYNAMIC; }
static               { return STATIC; }
true                 { return V_TRUE; }
false                { return V_FALSE; }
null                 { return V_NULL; }
{IDENTIFIER}         { 
                       strcpy (lisp_lval.identifier, lisp_text);
                       return IDENTIFIER; 
                     }
{DIGIT}+             {
                       lisp_lval.val_int = atoi (lisp_text);
                       return V_INT;
                     }
{DIGIT}+"."{DIGIT}*  {
                       lisp_lval.val_float = atof (lisp_text);
                       return V_FLOAT;
                     }
\"                   {
                        string_buf[0] = '\0';
                        string_buf_ptr = string_buf;
                        BEGIN(string);
                     }
<string>\\n          *string_buf_ptr++ = '\n';
<string>\\t          *string_buf_ptr++ = '\t';
<string>\\r          *string_buf_ptr++ = '\r';
<string>\\\"         *string_buf_ptr++ = '\"';
<string>\\\\         *string_buf_ptr++ = '\\';
<string>[^\"]    {
                        *string_buf_ptr++ = lisp_text[0];
                     }
<string>\"           {
                        *string_buf_ptr = '\0';
                        strcpy (lisp_lval.val_string, string_buf);
                        BEGIN(INITIAL);

                        return V_STRING;
                     }
[ \t\r]              /* White spaces */
[\n]                 { g_lang_line++; }

.		     { return lisp_text[0]; }






