/* X/lang - the eXtensible Language
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://xlang.sourceforge.net
 */

%{

#include <stdio.h>
#include <stdlib.h>

#include <xltype.h>
#include <xlexpr.h>

#include <xllang.h>
#include <langc_yacc.h>

xchar string_buf[10000];
xchar *string_buf_ptr;

%}

DIGIT		[0-9]
IDENTIFIER      [a-zA-Z_][a-zA-Z0-9_:]*

%x comment
%x string

%%

"//"+[^\n]+\n                 
"/*"                 BEGIN(comment);
<comment>[^*\n]*   
<comment>"*"+[^*/\n]*
<comment>\n          { g_lang_line++; };
<comment>"*"+"/"     BEGIN(INITIAL);

\"                   {
                        string_buf[0] = '\0';
                        string_buf_ptr = string_buf;
                        BEGIN(string);
                     }
<string>\\n          *string_buf_ptr++ = '\n';
<string>\\t          *string_buf_ptr++ = '\t';
<string>\\r          *string_buf_ptr++ = '\r';
<string>\\\"         *string_buf_ptr++ = '\"';
<string>\\\\         *string_buf_ptr++ = '\\';
<string>[^\"]    {
                        *string_buf_ptr++ = c_text[0];
                     }
<string>\"           {
                        *string_buf_ptr = '\0';
                        strcpy (c_lval.val_string, string_buf);
                        BEGIN(INITIAL);

                        return V_STRING;
                     }

"..."                { return OPT_PARAM; }
addr_of              { return ADDR_OF; }
import               { return IMPORT; }
if                   { return IF; }
ifdef                { return IFDEF; }
else                 { return ELSE; }
const                { return CONST; }
class                { return CLASS; }
native_class         { return NATIVE_CLASS; }
native_field         { return NATIVE_FIELD; }
native_method        { return NATIVE_METHOD; }
void                 { return VOID; }
char                 { return CHAR; }
uchar                { return UCHAR; }
short                { return SHORT; }
ushort               { return USHORT; }
int                  { return INT; }
uint                 { return UINT; }
float                { return FLOAT; }
double               { return DOUBLE; }
string               { return STRING; }
cstring              { return NATIVE_STRING; }
pointer              { return POINTER; }
bool                 { return BOOL; }
return               { return RETURN; }
for                  { return FOR; }
while                { return WHILE; }
dynamic              { return DYNAMIC; }
static               { return STATIC; }
true                 { return V_TRUE; }
false                { return V_FALSE; }
null                 { return V_NULL; }
{IDENTIFIER}         { 
                       strcpy (c_lval.identifier, c_text);
                       return IDENTIFIER; 
                     }
"-"?{DIGIT}+             {
                       c_lval.val_int = atoi (c_text);
                       return V_INT;
                     }
{DIGIT}+"."{DIGIT}*  {
                       c_lval.val_float = atof (c_text);
                       return V_FLOAT;
                     }
[ \t\r]              /* White spaces */
[\n]                 { g_lang_line++; }

.		     { return c_text[0]; }






