/* Grizzly Studio - the eXtensible Language IDE
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://www.freesoftware.fsf.org/xlang/
 */

import "document.xc";
import "project.xc";
import "editor.xc";
import "debugger.xc";
import "cvs.xc";

GtkFileSelection filesel;

class GrizzlyApp
{
  GrizzlyProject      project;
  GladeXML            glade_xml; 

  void init_directory ()
    {
      string path;

      path = g_get_home_dir () + "/.grizzly";
      if (sys_chdir (path) != 0)
	sys_mkdir (path, 770);
    }

  void init ()
    {
      glade_init();
      glade_xml = glade_xml_new ("./grizzly.glade", null);

      /* Registering events
       */

      glade_xml_signal_connect (glade_xml, "on_project_exit_activate", GrizzlyApp::on_project_exit_activate);
      glade_xml_signal_connect (glade_xml, "on_project_open_activate", GrizzlyApp::on_project_open_activate);

      /* Init directory
       */

      self.init_directory ();
    }

  static void on_project_exit_activate (GtkWidget widget)
    {
      io_write ("Exiting ...\n");
      sys_exit (0); 
    }

  static void on_project_open_activate (GtkWidget widget)
    {
      GtkWidget dlg;

      dlg = glade_xml_get_widget (grizzly.glade_xml, "project_open");

      gtk_widget_show (dlg);
    }

  static void on_run_run_activate (GtkWidget widget)
    {
      string cmd;
      
      str_setsize (cmd, 200);
      io_strwrite (cmd, "xlang \"%s\"", grizzly.project.documents[0].filename);
      
      io_write ("%s\n", cmd);
      
      sys_exec (cmd);
    }
}

GrizzlyApp grizzly;

void main (string args[])
{  
  grizzly.init ();

  gtk_main ();
}



