/* Database FrontEnd - the eXtensible Language IDE
 * Copyright (C) 2001 Patrick Deschenes
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* These files are distributed at http://xlang.sourceforge.net
 */

import "mysql.xc";

void dbfe_quit ()
{
  io_write ("Exiting ...\n");
  sys_exit (0); 
}

void query_clicked (pointer widget)
{
  MySQLField fld;
  pointer conn;
  pointer rs;
  pointer row_ref;
  pointer row[10];
  uint ptr;
  uint db;
  uint qry;
  uint num;
  uint i;
  uint r;
  string result;

  conn = mysql_connect (null, "127.0.0.1", "root", "test");
  db = mysql_select_db (conn, "mysql");
  qry = mysql_query (conn, "SELECT * FROM user");
  rs = mysql_use_result (conn);
  str_setsize (result, 1000);

  gtk_clist_clear (dbfe.cresult);
  num = mysql_num_fields (rs);

  i = 0;
  while (i < num)
    {
      fld = mysql_fetch_field (rs);
      io_strwrite (result, "%s%s  ", result, fld.name);
      gtk_clist_set_column_title (dbfe.cresult, i, fld.name);

      i = i + 1;
    }

  row_ref = mysql_fetch_row (rs);
  while (row_ref != 0)
    {
      gtk_clist_append (dbfe.cresult, row_ref);
      row_ref = mysql_fetch_row (rs);
    }
}

class DbfeApp
{
  GtkWidget   cresult;
  GtkWidget   entry;
  GtkWidget   query;
 
  void init ()
    {
      GtkWidget   frame;
      GtkWidget   hbox;
      GtkWidget   vbox;

      frame = gtk_window_new (GTK_WINDOW_TOPLEVEL);
      gtk_window_set_title (frame, "X Language - Dbfe Studio 0.1");
      gtk_widget_set_usize (frame, 600, 400);

      vbox = gtk_vbox_new (false, 0);
      hbox = gtk_hbox_new (false, 0);
      cresult = gtk_clist_new (10);

      entry = gtk_entry_new ();
      query = gtk_button_new_with_label ("Query");
      gtk_widget_set_usize (query, 10, 40);

      gtk_container_add (hbox, entry);
      gtk_container_add (hbox, query);

      gtk_container_add (frame, vbox);

      gtk_box_pack_start (vbox, hbox, false, false, 0);
      gtk_box_pack_end (vbox, cresult, true, true, 0);

      gtk_clist_column_titles_show (cresult);

      gtk_signal_connect (query, "clicked", query_clicked, null);

      gtk_signal_connect (frame, "destroy", dbfe_quit, null);
      gtk_widget_show_all (frame);
    }
}

DbfeApp dbfe;

void main (string args[])
{
  GdkColor color;

  dbfe.init ();

  /* Registering events
   */

  gtk_main ();
}


