/*
 *
 *  This file is part of the XForms library package.
 *
 * XForms is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1, or
 * (at your option) any later version.
 *
 * XForms is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with XForms; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 */


/**
 * \file ulib.h
 *
 *    Macros and Prototypes for the utilities routines
 */

#ifndef TC_ULIB_H
#define TC_ULIB_H

#include <stdio.h>		/* for FILE */


#ifndef FL_EXPORT
#  if ! defined FL_WIN32 || ! defined SHARED_LIB
#      define FL_EXPORT extern
#  else
#     ifdef MAKING_FORMS
#        define FL_EXPORT __declspec( dllexport ) extern
#     else
#       define FL_EXPORT __declspec( dllimport ) extern
#     endif                          /* MAKING_FORMS */
#  endif                          /* FL_WIN32 */
#endif     /* !def FL_EXPORT */


/***************** Portable IO operations *******************{**/

extern int fli_readint( FILE * );
extern int fli_readpint( FILE * );
extern int fli_readhexint( FILE * );
extern int fli_fget4MSBF( FILE * );
extern int fli_fput4MSBF( int,
						 FILE * );
extern int fli_fget2LSBF( FILE * );
extern int fli_fput2LSBF( int,
						 FILE * );
extern int fli_fget2MSBF( FILE * );
extern int fli_fput2MSBF( int,
						 FILE * );
extern int fli_fget4LSBF( FILE *);
extern int fli_fput4LSBF( int,
						 FILE * );


/********** End of  Portable IO *******************}**/

extern char * fli_de_space( char * );
extern char * fli_space_de( char * );
extern char * fli_de_space_de( char * );
extern char * fli_nuke_all_spaces( char * );
extern char * fli_nuke_all_non_alnum( char * );


/********* Variable number arguments strcat ******************/

extern char *fli_vstrcat( const char *,
					  ... );
extern void fli_free_vstrcat( void * );


/*********************************************************************
 * Basic error handling routines
 ********************************************************************/

#ifndef TC_ERROR_H
#define TC_ERROR_H

#include <errno.h>

/*
 * message levels(verbosity). Error generating routine should
 * have a (positive) control parameter specifying how loud
 * to bark (i.e., amount of messages generated)
 */

# define ML_ERR     ( -1 )
# define ML_WARN    0
# define ML_INFO1   1
# define ML_INFO2   2
# define ML_DEBUG   3
# define ML_TRACE   4

extern FL_ERROR_FUNC fli_whereError( int,
									 int,
									 const char *,
									 int );
extern FL_ERROR_FUNC efp_;
extern FL_ERROR_FUNC user_error_function_;


/*
 * define the actual names that will be used
 */

# define M_err    ( efp_ = fli_whereError( 0, ML_ERR,   __FILE__, __LINE__ ) ), efp_
# define M_warn   ( efp_ = fli_whereError( 0, ML_WARN,  __FILE__, __LINE__ ) ), efp_
# define M_info   ( efp_ = fli_whereError( 0, ML_INFO1, __FILE__, __LINE__ ) ), efp_
# define M_info2  ( efp_ = fli_whereError( 0, ML_INFO2, __FILE__, __LINE__ ) ), efp_
# define M_debug  ( efp_ = fli_whereError( 0, ML_DEBUG, __FILE__, __LINE__ ) ), efp_
# define M_trace  ( efp_ = fli_whereError( 0, ML_TRACE, __FILE__, __LINE__ ) ), efp_


/*
 * the actual output routines takes three constant strings and an integer
 * in the order title, where, why, 0
 */

typedef void ( * Gmsgout_ )( const char *,
							 const char *,
							 const char *,
							 int );

/****** Misc. control routines **********/

extern void fli_set_err_msg_func( Gmsgout_ );

extern void fli_set_msg_threshold( int );

extern const char *fli_get_syserror_msg( void );


#endif /* ERROR_H */

#endif /* TC_ULIB_H */
