/*
 *
 * This file is part of XForms.
 *
 * XForms is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1, or
 * (at your option) any later version.
 *
 * XForms is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with XForms; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "include/forms.h"


int main( int    argc,
		  char * argv[ ] )
{
	FL_FORM *simpleform;

	fl_initialize( &argc, argv, "FormDemo", 0, 0 );
	simpleform = fl_bgn_form( FL_UP_BOX, 230, 160 );
	fl_add_button( FL_NORMAL_BUTTON, 40, 50, 150, 60, "Push Me" );
	fl_end_form( );

	fl_show_form( simpleform, FL_PLACE_MOUSE, FL_NOBORDER, "PushMe" );

	fl_do_forms( );
	fl_hide_form( simpleform );
	return 0;
}
