/*
 *  This file is part of the XForms library package.
 *
 *  XForms is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU Lesser General Public License as
 *  published by the Free Software Foundation; either version 2.1, or
 *  (at your option) any later version.
 *
 *  XForms is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with XForms.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef PSELECT_H_
#define PSELECT_H_


typedef struct {
    FL_POPUP        * popup;
    FL_POPUP_RETURN * sel;
    int               align;
    int               style;
    int               size;
    FL_COLOR          color;
    int               timeout_id;
    long              repeat_ms;
} FLI_SELECT_SPEC;


#define FLI_SELECT_COL1          FL_COL1
#define FLI_SELECT_COL2          FL_MCOL
#define FLI_SELECT_LCOL          FL_LCOL
#define FLI_SELECT_ALIGN         FL_ALIGN_LEFT


#endif  /* PSELECT_H_ &*/


/*
 * Local variables:
 * tab-width: 4
 * indent-tabs-mode: nil
 * End:
 */
