Summary: XForms library
Name: xforms
Version: 1.0.94pre27
Release: 1
Source0: http://savannah.nongnu.org/download/xforms/%{name}-%{version}.tar.gz
License: LGPL
Group: System/Libraries
BuildRequires: xpm
BuildRequires: xpm-devel
BuildRoot: %{_tmppath}/%{name}-buildroot
Prefix: %{_prefix}
URL: http://xforms-toolkit.org/

%description
XForms is a GUI toolkit based on Xlib for X Window Systems. It
features a rich set of objects, such as buttons, sliders, and menus
etc. integrated into an easy and efficient object/event callback
execution model that allows fast and easy construction of
X-applications. In addition, the library is extensible and new objects
can easily be created and added to the library.

%package -n %{name}-devel
Summary: XForms development header files
Group: System/Libraries
Provides: %{name}

%description -n %{name}-devel
XForms header files for development.

%prep
%setup -q -n %{name}-%{version}

%build
./configure --prefix=%{_prefix} --mandir=%{_mandir} --bindir=%{_bindir} \
	--without-warnings --disable-debug --enable-optimization=-O2
make


%install
rm -rf ${RPM_BUILD_ROOT}
install -d -m 755 ${RPM_BUILD_ROOT}
make DESTDIR=${RPM_BUILD_ROOT} install
gzip -f9 ${RPM_BUILD_ROOT}%{_mandir}/man?/*
allfiles=`find ${RPM_BUILD_ROOT}/usr -type f -print | sed "s@^${RPM_BUILD_ROOT}@@g"`
echo "$allfiles" | grep -v "^/usr/include/" > \
	%{_tmppath}/%{name}-%{version}-binfiles
echo "$allfiles" | grep "^/usr/include/" > \
	%{_tmppath}/%{name}-%{version}-devfiles


%clean
rm -rf $RPM_BUILD_ROOT
rm -f %{_tmppath}/%{name}-%{version}-binfiles
rm -f %{_tmppath}/%{name}-%{version}-devfiles


%files -n %{name} -f %{_tmppath}/%{name}-%{version}-binfiles
%defattr(-,root,root)
%doc COPYING.LIB Copyright ChangeLog INSTALL INSTALL.git README


%files -n %{name}-devel -f %{_tmppath}/%{name}-%{version}-devfiles
%defattr(-,root,root)

%post -n %{name}
#
# Create symbolic links from libforms.so.1.2.0 to libforms.so, libforms.so.2
#
# 1. Create a list of files that require symbolic links.
#
lib_prefix=${RPM_INSTALL_PREFIX}/lib
sofiles=""
for file in \
	"${lib_prefix}/libforms.so"* \
	"${lib_prefix}/libformsGL.so"* \
	"${lib_prefix}/libflimage.so"*
do
	test -L "${file}" || sofiles="${sofiles} ${file}"
done
#
# 2. Create the links.
#
for file in ${sofiles}
do
	test -f "${file}" || continue
	symlink=`echo "${file}" | sed 's/\(\.so\.[0-9]\).*/\1/'`
	test "${file}" != "${symlink}" && ln -fs "${file}" "${symlink}"
	symlink=`echo "${symlink}" | sed 's/\(\.so\).*/\1/'`
	test "${file}" != "${symlink}" && ln -fs "${file}" "${symlink}"
done
#
# Modify libforms.la et al. to prevent libtool from complaining
# that the files have been moved.
#
test "${RPM_INSTALL_PREFIX}" = "/usr" && exit
for la_name in libforms.la libformsGL.la libflimage.la
do
	la_path="${lib_prefix}/${la_name}"
	tmp=`sed "/^libdir=/s@/usr@${RPM_INSTALL_PREFIX}@" ${la_path}`
	echo "${tmp}" > ${la_path}
done


%postun -n %{name}
#
# Remove symbolic links libforms.so, libforms.so.1, etc
#
lib_prefix=${RPM_INSTALL_PREFIX}/lib
for file in \
	"${lib_prefix}/libforms.so"* \
	"${lib_prefix}/libformsGL.so"* \
	"${lib_prefix}/libflimage.so"*
do
	test -L "${file}" && rm -f "${file}"
done


%changelog
* Thu Jun 1 2010 Jens Thoms Toerring <jt@toerring.de> 1.0.93sp1
- New release 1.0.93sp1

* Wed Nov 4 2009 Jens Thoms Toerring <jt@toerring.de> 1.0.93sp1
- New release 1.0.91sp2

* Sat Nov 22 2008 Jens Thoms Toerring <jt@toerring.de> 1.0.91
- New release 1.0.91 - lots of bug fixes

* Wed Oct 6 2004 Angus Leeming <angus.leeming@btopenworld.com> 1.0.90
- Re-write the 'post' and 'postun' scripts to create the
  symbolic links correctly without requiring the SO_VERSION hack.

* Fri May 7 2004 Angus Leeming <angus.leeming@btopenworld.com> 1.0.90
- add code to the 'post' script to modify libforms.la et al. to prevent
  libtool from complaining that the files have been moved.

* Thu May 6 2004 Angus Leeming <angus.leeming@btopenworld.com> 1.0.90
- fix 'Release' and 'Source0' info.
- add 'post' and 'postun' scripts to create and remove symbolic links,
  respectively.

* Thu May 6 2004 Angus Leeming <angus.leeming@btopenworld.com> 1.0.90
- no longer place devfiles and binfiles in ${RPM_BUILD_ROOT}.
  Prevents rpm from bombing with a "Checking for unpackaged files" error.

* Sat Aug 31 2002 Duncan Haldane <duncan_haldane@users.sourceforge.net> 1.0-RC4
- mv fdesign, fd2ps to devel.  restore xforms name of rpm.

* Sun Jul 14 2002 Greg Hosler <hosler@lugs.org.sg> 1.0-RC4
- Pass DESTDIR to makeinstall_std.

* Thu Jul 11 2002 Peter Galbraith <balbraith@dfo-mpo.gc.ca> 1.0-RC4
- Move from libxforms to libforms to match other distros.

* Tue Jul 8 2002 Chris Freeze <cfreeze@alumni.clemson.edu> 1.0-RC4
- First stab at spec file.
