#ifndef XDC_H
#define XDC_H

#include <tre/tre.h>
#include "xdxf.h"
#include "index.h"
#include "utf8.h"
#include "hash.h"
#include "file.h"
#include "conf.h"
#include "md5.h"

#define XDC_LIST_KEYS (0x1 << 0)
#define XDC_VERBOSE   (0x1 << 1)

#define PP_TO_LOWER        (0x1 << 0)
#define PP_CHOP_SPACES     (0x1 << 1)
#define PP_LEN_ARG1        (0x1 << 2)
#define PP_CROP_NONALPHA   (0x1 << 3)
#define PP_CROP_SPC        (0x1 << 4)
#define PP_ADD_PREF_DASH   (0x1 << 5)

#define XDXF_MD5_FULL (0x1 << 0)
#define XDXF_MD5_PART (0x1 << 1)

#define CC_DICT_PATH (0x1 << 0)
#define CC_VALID_PATH (0x1 << 1)


int lookup_article(xdc_conf_t *xdc_conf, fstat_lt *dict_fst, fstat_lt *index_fst, regex_t *preg, wchar_t *re, regex_t *preg_norm, wchar_t *re_norm);
long get_istart_pos(fstat_lt *dict, index_lt *index, wchar_t *key);
void key_to_art(xdc_conf_t *xdc_conf, wchar_t *re, wchar_t *re_norm);
void print_usage(void);
char *get_cfg_dir(void);
void print_line(int len);
void chomp_path(char* path);
void print_xdcdbs(xdcdb_t *db_ll);
void xdcdb_free_all(xdcdb_t *db_ll);
xdcdb_t* get_db_stat(char *path, unsigned flags);
int is_xdxf(char *path);
int is_idx(char *path);
int cmpwcs(wchar_t *user_key, wchar_t *dict_key, unsigned flags);
void crop_non_alnum(wchar_t *str);
void convert_xml_escape(wchar_t *str);
int pp_wcs(wchar_t *ppbuf, int ppbuf_len, wchar_t *wcs, unsigned flags);
char* gen_md5sum_full(char *path);
char* gen_md5sum_part(char *path, unsigned part_size, unsigned shift_len);
char* gen_md5sum_part2(char *path, unsigned part_size, unsigned nparts);
void print_nv(nameval_t *nv, int shift);

fstat_lt* search_dicts(xdc_conf_t *xdc_conf, unsigned flags);
char* find_output_dir(xdc_conf_t *xdc_conf);
int search_dict_path(xdc_conf_t *xdc_conf, fstat_lt **dict_flist_start, mbs_ll_t *mbsl, unsigned flags);
int search_cache_path(xdc_conf_t *xdc_conf, fstat_lt **dict_flist_start, mbs_ll_t *mbsl, unsigned cache_flags, unsigned flags);
fstat_lt* read_cache_file(char *path, unsigned flags, unsigned stat_flags);
fstat_lt* search_indexes(xdc_conf_t *xdc_conf, unsigned flags);
int search_index_path(xdc_conf_t *xdc_conf, fstat_lt **index_flist_start, mbs_ll_t *mbsl, unsigned flags);

md5_byte_t* md5_string2byte(char *md5_string);
char* md5_byte2string(md5_byte_t *digest);

int check_lang_from(xdc_conf_t *xdc_conf, fstat_lt *dict_fst);
int check_lang_to(xdc_conf_t *xdc_conf, fstat_lt *dict_fst);
int check_dict_name(xdc_conf_t *xdc_conf, fstat_lt *dict_fst);

void norm_key(wchar_t *key);
void wcs_lcase(wchar_t *str);
void shrink_norm_spaces(wchar_t *str);
wchar_t* re_start_literals(wchar_t *key);
wcs_ll_t* re_get_subre(xdc_conf_t *xdc_conf, wchar_t *re);

void norm_re(wchar_t *re);
void re_shrink_norm_spaces(wchar_t *re);
void re_crop_non_alnum(wchar_t *re);

void regaparams_set_defaults(regaparams_t *params);

#endif
