#ifndef REGEXP_UTF8_H
#define REGEXP_UTF8_H

#include <wchar.h>

#define RE_IGN_CASE        (0x1 << 0)
#define RE_COMP_SPACES     (0x1 << 1)
#define RE_STOP_WILDCARD   (0x1 << 2)
#define RE_SKIP_NONALPHA   (0x1 << 3)
#define RE_SKIP_START_SPC  (0x1 << 4)
#define RE_SKIP_END_SPC    (0x1 << 5)
#define RE_PREFIX_DASH     (0x1 << 6)
#define RE_SUFFIX_WEND     (0x1 << 7)
#define RE_SUFFIX_DOLLAR   (0x1 << 8)


typedef struct _retr_t retr_t;

int reg_test(wchar_t *data, wchar_t *re_text, unsigned flags, retr_t *retr);
int reg_test_8(char *data8, wchar_t *re_text, unsigned flags, retr_t *retr);

/* RETR - Regular Expression Test Result */
struct _retr_t {
  int is_set;
  int cmp_is_valid;
  int cmp_res;
};

int is_regexp_start(wchar_t *str);

#endif
