#ifndef FILE_H
#define FILE_H

#include <wchar.h>
#include "conf.h"

#define FF_CASE_INS      (0x1 << 0)
#define FF_MD5_FULL      (0x1 << 1)
#define FF_MD5_PART      (0x1 << 2)
#define FF_NO_DEEP       (0x1 << 3)
#define FF_NO_DIR_ENTER  (0x1 << 4)

#define FSTAT_MD5_FULL (0x1 << 0)
#define FSTAT_MD5_PART (0x1 << 1)

#define FR_FORCE (0x1 << 0)

typedef struct _fstat_lt fstat_lt;
struct _fstat_lt {
  char *path;
  unsigned long size;
  unsigned long mtime;
  unsigned long ctime;
  char *md5_full;
  char *md5_part;
  void *udata;
  unsigned udata_type;
  void (*udata_free)(void* udata);
  fstat_lt *next;
};


int file_exist(char *path);
int check_cfg(char *cfg_dir);
int can_rw(char *path);
int is_rfile(char *path);
int is_dir(char *path);
long file_size(char* path);
long file_mtime(char *path);
long file_ctime(char *path);
wchar_t* abs_path(wchar_t *path);
wchar_t* _abs_path(wchar_t *path);
char* abs_path_8(wchar_t *path);
char* get_prog_dir(char *argv0);
char* prog_locate(char *name);
int can_exec(char *path);
char* chop_path(char *path);
fstat_lt* find_file(char *path_in, char *pat, unsigned flags);
int fstat_update(fstat_lt *file, unsigned flags);
fstat_lt* fstat_create(void);
void flist_free(fstat_lt *file, unsigned flags);
void flist_print(fstat_lt *flist, int shift);
fstat_lt* fs_find(char *path_in, char *pat, unsigned flags);
void flist_dup_clean(xdc_conf_t *xdc_conf, fstat_lt *flist_start);
char* mbs_dirname(char *mbs);

#endif
