#ifndef HASH_H
#define HASH_H

#include <wchar.h>

#define NHASH 1024
//#define NHASH 32768
//#define NHASH (32768*128)
//#define NHASH (32768*1024)
#define MULTIPLIER 31

#define HT_SKIP_STR (0x1 << 0)
#define HT_FORCE    (0x1 << 1)

typedef struct _nameval_t nameval_t;
struct _nameval_t {
    char *name;
	char *mbs_val;
	wchar_t *wcs_val;
	int ival;
    void *val;
	unsigned val_type;
	void (*val_free)(void* val);
    nameval_t* next;
};

typedef struct _wnameval_t wnameval_t;
struct _wnameval_t {
    wchar_t *name;
	char *mbs_val;
	wchar_t *wcs_val;
	int ival;
    void *val;
	unsigned val_type;
	void (*val_free)(void* val);
    wnameval_t* next;
};

nameval_t* hlookup(void* symtab_in, const char* name, int create);
wnameval_t* whlookup(void* symtab_in, const wchar_t* name, int create);
unsigned int hash(const char *str);
unsigned int whash(const wchar_t *str);
void htable_free(void *symtab, unsigned flags);
void htable_regex_free(void *symtab_in, char *pat, unsigned flags);
void whtable_free(void *symtab, unsigned flags);
void whtable_regex_free(void *symtab_in, wchar_t *pat, unsigned flags);
void* create_htable(void);
void hash_init(void*);
void print_htable(void *_symtab, void (*nv_print)(nameval_t*, int), int shift);
void print_whtable(void *_symtab, void (*nv_print)(wnameval_t*, int), int shift);

#endif
