#ifndef XDXF_H
#define XDXF_H

#ifdef TARGET_FREEBSD
#include <sys/types.h>
#else
#include <stdint.h>
#endif
#include <stdio.h>
#include "xml_utf8.h"
#include "file.h"

#define OPTS_8 1

#if defined(OPTS_8)
#define MAXOPTS 8
#elif defined(OPTS_16)
#define MAXOPTS 16
#elif defined(OPTS_32)
#define MAXOPTS 32
#else
#define OPTS_16 1
#define MAXOPTS 16
#endif

#define KTAG_INDEX_16 1

typedef struct _article_t article_t;
struct _article_t {
  wchar_t *key;
  wchar_t *article;
  long ar_start_pos;
  long ar_size;
/*  idxfile_t *idx; */
};

typedef struct _wkey_t wkey_t;
struct _wkey_t {
  wchar_t *key;
  article_t **arts;
  int narts;
};

typedef struct _key_ll_t key_ll_t;
struct _key_ll_t {
  wchar_t *key;
#if defined (KTAG_INDEX_16)
  uint16_t ktag_index;
#else
  uint32_t ktag_index;
#endif

#if defined(OPTS_8)
  uint8_t kmask;
#elif defined(OPTS_16)
  uint16_t kmask;
#elif defined(OPTS_32)
  uint32_t kmask;
#endif

  DTag *tag;
  key_ll_t *prev;
  key_ll_t *next;
};

typedef struct _keypart_t {
  wchar_t *str;
  int is_opt;
} keypart_t;

typedef struct _xdcdb_t xdcdb_t;
struct _xdcdb_t {
  char *path;
  unsigned long size;
  unsigned long mtime;
  unsigned long ctime;
  char *md5_full;
  char *md5_part;
  xdcdb_t *next;
};


#define OPT1 (1 << 0)
#define OPT2 (1 << 1)
#define OPT3 (1 << 2)
#define OPT4 (1 << 3)
#define OPT5 (1 << 4)
#define OPT6 (1 << 5)
#define OPT7 (1 << 6)
#define OPT8 (1 << 7)
#define OPT9 (1 << 8)
#define OPT10 (1 << 9)
#define OPT11 (1 << 10)
#define OPT12 (1 << 11)
#define OPT13 (1 << 12)
#define OPT14 (1 << 13)
#define OPT15 (1 << 14)
#define OPT16 (1 << 15)
#define OPT17 (1 << 16)
#define OPT18 (1 << 17)
#define OPT19 (1 << 18)
#define OPT20 (1 << 19)
#define OPT21 (1 << 20)
#define OPT22 (1 << 21)
#define OPT23 (1 << 22)
#define OPT24 (1 << 23)
#define OPT25 (1 << 24)
#define OPT26 (1 << 25)
#define OPT27 (1 << 26)
#define OPT28 (1 << 27)
#define OPT29 (1 << 28)
#define OPT30 (1 << 29)
#define OPT31 (1 << 30)
#define OPT32 (1 << 31)

#if defined(OPTS_8)
#define MAXOPT OPT8
#elif defined(OPTS_16)
#define MAXOPT OPT16
#elif defined(OPTS_32)
#define MAXOPT OPT32
#else
#define MAXOPT 0
#endif


DTag* read_xdxf(char *path, long shift, long siz, FILE *dfp);
key_ll_t* fill_opts(keypart_t *key_parts, int kp_len, DTag *tag_ar, key_ll_t *optkeys, int ktag_index);
key_ll_t* sort_keys(key_ll_t *key_start);
void kl_base_opt_merge(key_ll_t **keys, int nkeys, key_ll_t *optkeys);
int cmpkeys(const void *p1, const void *p2);
int dup_remove(key_ll_t **keys, int *klen);
int dup_remove2(key_ll_t *key_start);
int keys_tolower(key_ll_t **keys, int nkeys);
int keys_tolower2(key_ll_t *key_start);
int start_spaces_remove(key_ll_t **keys, int nkeys, int sorted);
int start_spaces_remove2(key_ll_t *key_start, int sorted);
wchar_t* get_key_by_mask(keypart_t *key_parts, int kp_len, unsigned opt_mask);
int count_keys(keypart_t *key_parts, int kp_len);
int count_opt_keys(keypart_t *key_parts, int kp_len);
int ktag_index_len(void);
int crop_nonalpha(key_ll_t **keys, int klen);
int crop_nonalpha2(key_ll_t *key_start);
int kll_shrink_norm_spaces(key_ll_t **keys, int klen);
int kll_shrink_norm_spaces2(key_ll_t *key_start);
int find_xdxf(char *path_in, xdcdb_t **db_ret, unsigned flags);
int get_lang(xdc_conf_t *xdc_conf, fstat_lt *dict, char **lang_from_ret, char **lang_to_ret);
int get_lang_in_path(char *path, char **lang_from, char **lang_to);
int get_full_name(xdc_conf_t *xdc_conf, fstat_lt *dict, wchar_t **name_ret);
wchar_t* get_name_in_path(char *path);
int get_description(xdc_conf_t *xdc_conf, fstat_lt *dict, wchar_t **descr_ret);

typedef enum {
  XDTAG_NULL,
  XDTAG_UNDEF,
  XDTAG_VALUE,

  XDTAG_XDXF,
  XDTAG_FULL_NAME,
  XDTAG_DESCRIPTION,
  XDTAG_ABBREVIATIONS,
  XDTAG_ABR_DEF,
  XDTAG_V,
  XDTAG_AR,
  XDTAG_I,
  XDTAG_B,
  XDTAG_K,
  XDTAG_OPT,
  XDTAG_DEF,
  XDTAG_POS,
  XDTAG_TENSE,
  XDTAG_TR,
  XDTAG_DTRN,
  XDTAG_KREF,
  XDTAG_RREF,
  XDTAG_IREF,
  XDTAG_ABR,
  XDTAG_C,
  XDTAG_EX,
  XDTAG_CO,
  XDTAG_SUP,
  XDTAG_SUB,

  XDTAG_NU,
  XDTAG_SU,
  XDTAG_TT,
  XDTAG_BIG,
  XDTAG_SMALL,
  XDTAG_BLOCKQUOTE,
} xdtag_id_t;

#endif
