#ifndef INDEX_H
#define INDEX_H

#include "xdxf.h"
#include "conf.h"
#include "file.h"

#define KPMAX 32

#define H_IDX_MD5_FULL  (0x1 << 0)
#define H_IDX_MD5_PART  (0x1 << 1)

typedef struct _index_lt index_lt;
struct _index_lt {
  char *index_path;
  unsigned long index_size;
  unsigned long index_body_size;
  unsigned long index_body_start;
  unsigned ktag_index_len;
  unsigned mask_len;
  unsigned long dict_size;
  unsigned long dict_mtime;
  unsigned long dict_ctime;
  char *dict_md5_full;
  char *dict_md5_part;
  int set_lang_from;
  int set_lang_to;
  unsigned long full_name_pos;
  unsigned full_name_len;
  unsigned long descr_pos;
  unsigned descr_len;
  unsigned arnum;
  unsigned idx_version;
  index_lt *next;
};

typedef struct _xdcidx_t xdcidx_t;
struct _xdcidx_t {
  char *path;
  xdcidx_t *next;
};

typedef struct _xdxf_idx_t xdxf_idx_t;
struct _xdxf_idx_t {
  index_lt *index;
  uint32_t shift;
  uint32_t size;
  unsigned ktag_index;
  unsigned mask;
};

/* HDI - index Header Data Id */
typedef enum _hdi_t {
  HDIundef = 0,
  HDIsize,
  HDImtime,
  HDIctime,
  HDImd5full,
  HDImd5part,
  HDIktag_index_len,
  HDImask_len,
  HDIbody_start,
  HDIset_lang_from,
  HDIset_lang_to,
  HDIfull_name,
  HDIdescription,
  HDIversion,
  HDIarnum
} hdi_t;

void print_idx_header(index_lt *idxfile);
void clean_index_struct(index_lt *index);
int read_idx_header(index_lt *idxfile);
int idx_clean(char *cfg_dir);
int idx_file_create(fstat_lt *db, char *index_path, key_ll_t **keys, int klen, int arnum, DTag *tag_root);
int write_idx_header(FILE *index_fp, index_lt *idxfile, fstat_lt *dict);
int update_idx_header(index_lt *idxfile, fstat_lt *dict);
int gen_index(xdc_conf_t *xdc_conf);
int _gen_index(fstat_lt *dict, char *index_file);
void idx_free_all(xdcidx_t *idx);
key_ll_t* base_key_fetch(keypart_t *kp, int kp_len);
void free_base_keys(key_ll_t **keys, int nkeys);
void free_opt_keys(key_ll_t *optkeys);
int keyparts_fetch(DTag *tag_key, keypart_t *key_parts, int kpsize);
int count_key_tags(DTag *tag_xdxf);
int count_ar_tags(DTag *tag_xdxf);
void free_key_parts(keypart_t *key_parts, int kp_len);
wchar_t* read_key_by_idx(fstat_lt *dict, xdxf_idx_t *idx, FILE *dfp);
void free_keys(key_ll_t **keys, int nkeys);
void index_list_free(index_lt *index);
int validate_index(index_lt *idxfile);

void init_index_lt(index_lt *index);
void free_index_lt(index_lt *index);
index_lt* read_index_file(char *path);
int dup_index_remove(xdc_conf_t *xdc_conf, fstat_lt *flist_start);
int load_indexes(fstat_lt *flist_start);
int load_index(fstat_lt *flist);
int hash_indexes(xdc_conf_t *xdc_conf, fstat_lt *flist_start, unsigned flags);
void unhash_indexes(xdc_conf_t *xdc_conf);

#endif
