/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file main.cc Defines the entry-point into the program. */

/** @namespace XBobble

    Global namespace for everything XBobble-related. */

#include <iostream>
#include <stdexcept>
#include <typeinfo>
#include <memory>
#include "Game_Manager.hh"

/// The entry point into the program.
int
main(int argc, char** argv)
{
	try
	{
		std::ios::sync_with_stdio(false);
		XBobble::Game_Manager g("");
		return 0;
	}
	catch(std::runtime_error& e)
	{
		std::cerr << "Error: " << e.what() << std::endl;
		return -1;
	}
	catch(std::bad_exception)
	{
		std::cerr << "Bad exception!\n" << std::endl;
		return -5;
	}

} // main()

