/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file glstuff.hh Misc routines useful in all GL programming */

#ifndef XBOBBLE_GLSTUFF_HH
#define XBOBBLE_GLSTUFF_HH

#include <SDL_opengl.h>

namespace XBobble
{


/// Very inefficiently call glMaterialfv with given parms separated
/// out.
inline void
call_glMaterialfv(GLenum face, GLenum pname, GLfloat p0,  GLfloat p1,
		  GLfloat p2, GLfloat p3)
{
	GLfloat tmp[4];
	tmp[0] = p0;
	tmp[1] = p1;
	tmp[2] = p2;
	tmp[3] = p3;
	glMaterialfv(face, pname, tmp);
}

/// Create a quad made of 4 by 4 squares, facing the -z direction, on
/// the x/y plane.  Obviously, it must have dimensions greater than
/// 4x4, and width/height must be multiples of 4 (vals are modified to
/// suit)
inline void
create_tess_rect_of_4by4(int32_t tw, int32_t th)
{
	// If not atleast 8, round up to 8
	if(tw < 8)
		tw = 8;
	if(th < 8)
		th = 8;

	// If either dimensions not multiples of 4, round down to
	// nearest multiple of 4
// 	if((int32_t diff = tw%4) != 0)
// 		tw -= diff;
// 	if((int32_t diff = th%4) != 0)
// 		th -= diff;
	tw -= tw%4;
	th -= th%4;

	// Tesselate a quad
	for(int32_t x = 0; x != tw; x += 4) {
		glBegin(GL_QUAD_STRIP); // 1 2 4 3
		glTexCoord2f(1.0f*(x+4)/tw, 0);
		glVertex3i(x+4, 0, 0); // topright
		glTexCoord2f(1.0f*x/tw, 0);
		glVertex3i(x, 0, 0); // topleft
		for(int32_t y = 0; y != th; y += 4) {
			glTexCoord2f(1.0f*(x+4)/tw, 1.0f*(y+4)/th);
			glVertex3i(x+4, y+4, 0); // btmright
			glTexCoord2f(1.0f*x/tw, 1.0f*(y+4)/th);
			glVertex3i(x, y+4, 0); // btmleft
		}
		glTexCoord2f(1.0f*(x+4)/tw, 1.0f);
		glVertex3i(x+4, th, 0); // btmright
		glTexCoord2f(1.0f*x/tw, 1.0f);
		glVertex3i(x, th, 0); // btmleft
		glEnd();
	}
}


} // namespace XBobble


#endif // #define XBOBBLE_GLSTUFF_HH

