/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Video_Output_Manager.hh a Video_Output_Manager file for easy
    creation of new files */

#ifndef XBOBBLE_VIDEO_OUTPUT_MANAGER_HH
#define XBOBBLE_VIDEO_OUTPUT_MANAGER_HH

#include <vector>
#include <map>
#include <cstdlib>
#include <stdexcept>
#include <ayq/stdint.h>
#include "util.hh"
#include "Video_Data.hh"

struct SDL_Surface;

namespace XBobble
{

class System;

/// Manages video output.
class Video_Output_Manager : public Singleton_Class
{
	/// Yep
	class Pimpl;
public:
	/// Init the SDL screen
	Video_Output_Manager(System& arg_sys);

	/// Gets the screen width from options
	int
	get_width() const;

	/// Gets the screen height from options
	int
	get_height() const;

	/// Gets the fullscreen status from options
	bool
	get_fullscreen() const;

	/// Switches from fullscreen to windowed (if possible) and
	/// sets appropriate option.
	void
	switch_fullscreen();

	/// Resizes drawing area if needed according to options.
	void
	resize();

	/// Clears the screen
	void
	clear_screen();

	/// Draws the screen and flips buffers
	void
	draw_screen();

	/// Register a Video_Data object with this manager.
	void
	register_data(Video_Data* arg);

	//@{

	/// Gets texture with the given name (determined by
	/// 'data_root' config option)
	uint32_t
	get_texture(const std::string& name);

	uint32_t
	get_texture(const char* name);
	//@}

private:
	/// The system that created this object
	System& system;

	/// The screen created by SDL
	SDL_Surface* screen;

	/// That's right
	Pimpl* impl;

}; // Video_Output_Manager


} // namespace XBobble


#endif // #define XBOBBLE_VIDEO_OUTPUT_MANAGER_HH

