/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Video_Data.hh @see Video_Output_Manager.hh */

#ifndef XBOBBLE_VIDEO_DATA_HH
#define XBOBBLE_VIDEO_DATA_HH

namespace XBobble
{

class Video_Output_Manager;

/// Register objects of this or derived classes with
/// Video_Output_Manager to have something put on the screen.
/// Function 'draw()' does all the work.  Implementation in
/// Video_Output_Manager.hh
class Video_Data
{
public:
	/// Set default params
	Video_Data()
	 : drawing_enabled(false)
	{
	}

	/// Because It Should Be There (tm)
	virtual
	~Video_Data()
	{
	}

protected:
	/** Override to do drawing, ie GL commands.

	    Note on drawing commands:

	    Coord system is right-hand rule, origin in centre of
	    screen, +x goes right, +y goes __down__, +z goes into
	    screen (away from the viewer.)

	    Screen viewport from -100 to 100 horizontally, and -75 to
	    75 vertically.  Camera is at vertex (0, 0, -500) looking
	    towards the origin, up direction being (0, -1, 0).  Near
	    clipping plane is at z=500, far at z=1000.
	 */
	virtual void
	draw_handler() const = 0;

public:
	/// Draw me if 'enabled' is set to true.
	virtual void
	draw()
	{
		if(drawing_enabled)
			this->draw_handler();
	}

	/// Enable/disable drawing.  Calls 'enable_drawing_handler()',
	/// which can be overridden.
	void
	enable_drawing(bool arg)
	{
		drawing_enabled = arg;
		this->enable_drawing_handler(arg);
	}

private:
	/// Override for more functionality regarding
	/// enabling/disabling video output.
	virtual void
	enable_drawing_handler(bool)
	{
	}

	/// Set to true to enable drawing, false to disable (initially
	/// false)
	bool drawing_enabled;

}; // class Video_Data


} // namespace XBobble


#endif // #define XBOBBLE_VIDEO_DATA_HH
