/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file System.cc @see System.hh */

#include "System.hh"
#include <SDL.h>
#include <cstdlib>
#include <ctime>
#include <csignal>
#include <iostream>

namespace XBobble
{

namespace
{

/// An empty SDL_Event that is used to put an 'SDL_QUIT' message on
/// the SDL event queue when a signal is received
SDL_Event quit_event = {SDL_QUIT};

void
time_to_exit(int)
{
	SDL_PushEvent(&quit_event);
}

} // namespace

System::SDL_Initialiser::SDL_Initialiser()
 : Singleton_Class("System::SDL_Initialiser")
{
	if(SDL_Init(SDL_INIT_VIDEO | SDL_INIT_AUDIO | SDL_INIT_JOYSTICK
		    | SDL_INIT_NOPARACHUTE) == -1)
		throw Init_Error("System() - SDL_Init() failed");
}

System::SDL_Initialiser::~SDL_Initialiser()
{
	SDL_Quit();
	std::cerr << "Quitting SDL\n";
}

System::System(Game_Manager& arg_gman)
 : Singleton_Class("System"), game_manager(arg_gman),
   sdl_initialiser(), video_output_manager(*this),
   sound_output_manager(*this), user_input_manager(*this)
{
	std::signal(SIGHUP, time_to_exit);
	std::signal(SIGINT, time_to_exit);
	std::signal(SIGQUIT, time_to_exit);
	std::signal(SIGKILL, time_to_exit);
	std::signal(SIGTERM, time_to_exit);

	std::srand(std::time(0));
}

void
System::signal_exit()
{
	time_to_exit(0);
}


} // namespace XBobble



