/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Game_Over_State.cc @see Game_Over_State.hh */

#include "Game_Over_State.hh"
#include "Game.hh"
#include "Game_Manager.hh"
#include <iostream>

namespace XBobble
{

class Game_Over_State::Pimpl
{
	/// How long (in tocks) to keep the gameover screen going
	/// (counts down to 0)
	uint32_t until_exit;

	/// Display list for 'Game Over' logo
	uint32_t dlist;

}; // class Game_Over_State::Pimpl

Game_Over_State::Game_Over_State(Game::Impl& arg)
 : State(arg)
{
// 	texname = vo.get_texture("images/intro.png");
// 	Video_Output_Manager& vo
// 		= game.game_manager.system.video_output_manager;
// 	vo.register_data(this);
// 	dlist = glGenLists(1);
// 	glNewList(dlist, GL_COMPILE); {
// 		const int32_t tw = 360, th = 240; // pleez make these
// 		// multiples of 4!!!!
// 		glTranslatef(-tw/2, -th/2, 0);
// 		glBindTexture(GL_TEXTURE_2D, texname);
// 		glMaterialf(GL_FRONT, GL_SHININESS, 100);
// 		call_glMaterialfv(GL_FRONT, GL_AMBIENT,
// 				  0.8f, 0.8f, 0.8f, 1);
// 		call_glMaterialfv(GL_FRONT, GL_DIFFUSE,
// 				  0.8f, 0.8f, 0.8f, 1);
// 		call_glMaterialfv(GL_FRONT, GL_SPECULAR,
// 				  1.0f, 1.0f, 1.0f, 1);
// 		glNormal3f(0, 0, -1);
// 		create_tess_rect_of_4by4(tw, th);
// 	}; glEndList();
}

void
Game_Over_State::entry()
{
// 	until_exit = 100;
	std::cout << "Game over\n";
	std::cout.flush();
}

void
Game_Over_State::exit()
{
}

void
Game_Over_State::tock(uint32_t tocks_passed)
{
	game.set_state(Game::OUT_OF_GAME);
// 	--until_exit;
// 	if(!until_exit)
// 		game.set_state(Game::OUT_OF_GAME);
}

void
Game_Over_State::tick(uint32_t)
{
}

void
Game_Over_State::sync_tick(uint32_t)
{
}

void
Game_Over_State::draw_handler() const
{
}


} // namespace XBobble


