/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Finished_Level_State.hh */

#ifndef XBOBBLE_FINISHED_LEVEL_STATE_HH
#define XBOBBLE_FINISHED_LEVEL_STATE_HH

#include <ayq/stdint.h>
#include <stdexcept>
#include <string>
#include "State.hh"

namespace XBobble
{

class Game;

/// Display success animation while loading next level.
class Finished_Level_State : public State
{
public:
	/// Init with game
	Finished_Level_State(Game::Impl& arg);

	/// Destroy!
	virtual
	~Finished_Level_State();

	/// Reset first level to 0
	void
	reset();

	/// Call on entering this finished_level_state
	void
	entry();

	/// Call on leaving this finished_level_state
	void
	exit();

	/// Do tock processing
	void
	tock(uint32_t);

	/// Tick-based function for this finished_level_state
	void
	tick(uint32_t);

	/// Sync-tick function for this finished_level_state
	void
	sync_tick(uint32_t);

private:
	/// Yep
	class Impl;

	/// Oh yeah...
	Impl* impl;

}; // class Finished_Level_State


} // namespace XBobble

#endif// #define XBOBBLE_FINISHED_LEVEL_STATE_HH


