/* Copyright (C) 2002 Asfand Yar Qazi.

 This file is part of XBobble.

    XBobble is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    XBobble is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with XBobble; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */

/** @file Chooser.cc @see Chooser.hh */

#include "Chooser.hh"
#include "Game.hh"
#include "Game_Manager.hh"
#include "Grid.hh"
#include <SDL_opengl.h>

namespace XBobble
{

class No_Traits_Error { };

Chooser::Chooser(Game::Impl& arg)
 : Game_Element(arg), ball(0, -get_grid().get_w()/2,
			   get_grid().get_h()/2 + get_grid().get_r()*2,
			   0.0f, 0.0f)
{
	try
	{
		ball.trait = get_grid().get_random_trait();
	}
	catch(No_Traits_Error)
	{
		throw std::out_of_range("Chooser() - "
					"from Grid::get_random_trait() - "
					"no traits!");
	}
	game.game_manager.system.video_output_manager.register_data(this);
}

void
Chooser::draw_handler() const
{
	glDisable(GL_TEXTURE_2D);
	get_grid().draw_ball_commands(ball);
}

std::size_t
Chooser::get_next_ball()
{
	std::size_t tmp = ball.trait;
	try {
		ball.trait = get_grid().get_random_trait();
	} catch(No_Traits_Error) {
		;
	}
	return tmp;
}

void
Chooser::reset()
{
	try {
		ball.trait = get_grid().get_random_trait();
	} catch(No_Traits_Error) {
		;
	}
}

} // namespace XBobble


