{-
Input.hs

Xadrez - A p2p chess written in Haskell
Copyright (C) 2004-2005 Marco Tulio Gontijo e Silva, Rafael Cunha Almeida

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}
module Input (readPlace, isExit, change)
    where

import Maybe
import Char

import Board
import Tests

exit :: String
exit = "!Q"

readPlace :: IO String
readPlace
    = do putStr "\nMove (! to quit): \a"
	 getLine

isExit :: String -> Bool
isExit [] = False
isExit s = ((flip elem exit) . toUpper . head) s

change :: Board -> Bool -> Bool -> String -> Maybe (Place, Place)
change b p your place
    | correct p1 p2 && valid b' p p1'' p2''
	= Just (p1', p2')
    | otherwise = Nothing
    where (p1, p2) = divide place'
	  place' = map toUpper place
	  b' = if your then b else inverse b
	  p1' = if your then change1 p1 else deny $ change1 p1
	  p2' = if your then change1 p2 else deny $ change1 p2
	  p1'' = change1 p1
	  p2'' = change1 p2

divide :: String -> (String, String)
divide place = (p1, p2)
    where p1 = takeWhile (/= ' ') $ dropWhile
	       (\n -> (n == ' ') || n == '|') place
	  p2 = filter (/= ' ') $ dropWhile (/= ' ') place

change1 :: String -> Place
change1 (litero : numero) = (i, j)
    where i = read numero - 1
	  j = (ord $ toUpper litero) - ord 'A'
change1 _ = error "Input.change1 called with an unexpected parameter"

deny :: Place -> Place
deny (i, j) = (7 - i, j)