{-
Main.hs

Xadrez - A p2p chess written in Haskell
Copyright (C) 2004 Rafael Cunha Almeida
Copyright (C) 2004-2005 Marco Tulio Gontijo e Silva

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}
module Main where

import Char
import Maybe
import Network
import IO

import Board
import Input
import Connection
import Opts

showHisMove :: String
showHisMove = "\nHis move: "

main :: IO ()
main
    = do
      hSetBuffering stdout NoBuffering
      fs <- doOpts
      treat (PortNumber 13033) fs

treat :: PortID -> [Flag] -> IO ()
treat _ (Version : _) = showVersion
treat _ (Help : _) = showHelp
treat _ (Port port : xs) = treat port xs
treat port (Server : _) = serverGame port
treat port [] = clientGame port
      
showVersion, showHelp :: IO ()
showVersion = putStrLn "Xadrez 0.1.1"
showHelp
    = putStrLn $
      "Usage: xadrez [-s] [-p PORT]\n" ++
      "       xadrez -v\n" ++
      "       xadrez -h\n\n" ++
      "Simple Haskell implementation of the chess game using p2p.\n\n" ++
      "Options:\n" ++
      "        -s, --server             Start xadrez as server.\n" ++
      "        -p PORT, --port PORT     Change the port used by xadrez.\n" ++
      "        -v, --version            Display version information.\n" ++
      "        -h, --help               Display a help message.\n\n" ++
      "PORT may be a valid port. By default it uses 13033."

serverGame, clientGame :: PortID -> IO ()

serverGame port
    = withSocketsDo $
      do h <- server port
         putStr $ show (standard white)
	 game h (standard white) white

clientGame port
    = withSocketsDo $ 
      do putStr "\nServer IP: "
	 ip <- getLine
	 h <- client port ip
         putStr $ show (standard black)
	 hisMove <- read' h
	 let hisMove' = change (standard black) white False hisMove
	     new = flip move (standard black) $ fromJust hisMove'
	 putStrLn (showHisMove ++ hisMove)
	 putStr $ show new
	 game h new black

game :: Handle -> Board -> Bool -> IO ()
game h old player
    = do yourMove <- readPlace
	 let yourMove' = change old player True yourMove
	     new = flip move old $ fromJust yourMove'
	 if not $ isExit yourMove
	    then if yourMove' /= Nothing
		    then do putStr $ show new
			    send h yourMove
			    hisMove <- read' h
			    let hisMove' = change new (not player) False
				           hisMove
				newest = flip move new $ fromJust hisMove'
			    putStrLn (showHisMove ++ hisMove)
			    putStr $ show newest
			    game h newest player
		    else game h old player
	    else return ()
