/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.lang;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.ext.DefaultHandler2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum X4OLanguageProperty {
    LANGUAGE_NAME(IO.GLOBAL, "language/name"),
    LANGUAGE_VERSION(IO.GLOBAL, "language/version"),
    READER_INPUT_STREAM(IO.READER, "reader/input/stream", InputStream.class),
    READER_INPUT_ENCODING(IO.READER, "reader/input/encoding", String.class, (Object)"UTF-8"),
    READER_INPUT_SOURCE(IO.READER, "reader/input/source", InputSource.class),
    READER_INPUT_SYSTEM_ID(IO.READER, "reader/input/system-id", String.class),
    READER_INPUT_BASE_PATH(IO.READER, "reader/input/base-path", URL.class),
    READER_BUFFER_SIZE(IO.READER, "reader/buffer-size", Integer.class, (Object)8192),
    READER_EMPTY_NAMESPACE_URI(IO.READER, "reader/empty-namespace-uri"),
    READER_ERROR_HANDLER(IO.READER, "reader/error-handler", ErrorHandler.class),
    READER_ENTITY_RESOLVER(IO.READER, "reader/entity-resolver", EntityResolver.class),
    READER_VALIDATION_SCHEMA_AUTO_WRITE(IO.READER, "reader/validation/schema-auto-write", Boolean.class, (Object)true),
    READER_VALIDATION_SCHEMA_PATH(IO.READER, "reader/validation/schema-path", File.class),
    READER_VALIDATION_INPUT(IO.READER, "reader/validation/input", Boolean.class, (Object)false),
    READER_VALIDATION_INPUT_XSD(IO.READER, "reader/validation/input/xsd", Boolean.class, (Object)false),
    WRITER_OUTPUT_STREAM(IO.WRITER, "writer/output/stream", OutputStream.class),
    WRITER_OUTPUT_ENCODING(IO.WRITER, "writer/output/encoding", String.class, (Object)"UTF-8"),
    WRITER_OUTPUT_CHAR_NEWLINE(IO.WRITER, "writer/output/char/newline", String.class),
    WRITER_OUTPUT_CHAR_TAB(IO.WRITER, "writer/output/char/tab", String.class),
    WRITER_SCHEMA_URI_PRINT(IO.WRITER, "writer/schema/uri-print", Boolean.class, (Object)true),
    WRITER_SCHEMA_URI_ROOT(IO.WRITER, "writer/schema/uri-root", String.class),
    SCHEMA_WRITER_OUTPUT_PATH(IO.SCHEMA_WRITER, "schema-writer/output/path", File.class),
    SCHEMA_WRITER_OUTPUT_ENCODING(IO.SCHEMA_WRITER, "schema-writer/output/encoding", String.class, (Object)"UTF-8"),
    SCHEMA_WRITER_OUTPUT_CHAR_NEWLINE(IO.SCHEMA_WRITER, "schema-writer/output/char/newline", String.class),
    SCHEMA_WRITER_OUTPUT_CHAR_TAB(IO.SCHEMA_WRITER, "schema-writer/output/char/tab", String.class),
    DEBUG_OUTPUT_STREAM(IO.READER_WRITER, "debug/output-stream", OutputStream.class),
    DEBUG_OUTPUT_HANDLER(IO.READER_WRITER, "debug/output-handler", DefaultHandler2.class),
    EL_BEAN_INSTANCE_MAP(IO.READER_WRITER, "el/bean-instance-map", Map.class),
    EL_CONTEXT_INSTANCE(IO.READER_WRITER, "el/context-instance", ELContext.class),
    EL_FACTORY_INSTANCE(IO.READER_WRITER, "el/factory-instance", ExpressionFactory.class),
    PHASE_STOP_AFTER(IO.READER_WRITER, "phase/stop-after", String.class),
    PHASE_SKIP_RELEASE(IO.READER_WRITER, "phase/skip-release", Boolean.class, (Object)false),
    PHASE_SKIP_RUN(IO.READER_WRITER, "phase/skip-run", Boolean.class, (Object)false);

    public static final X4OLanguageProperty[] DEFAULT_X4O_READER_KEYS;
    public static final X4OLanguageProperty[] DEFAULT_X4O_WRITER_KEYS;
    public static final X4OLanguageProperty[] DEFAULT_X4O_SCHEMA_WRITER_KEYS;
    private static final String URI_PREFIX = "http://language.x4o.org/xml/properties/";
    private final String uriName;
    private final Class<?>[] classTypes;
    private final Object defaultValue;
    private final IO type;

    private X4OLanguageProperty(IO type, String uriName) {
        this(type, uriName, String.class);
    }

    private X4OLanguageProperty(IO type, String uriName, Class<?> classType) {
        this(type, uriName, new Class[]{classType}, null);
    }

    private X4OLanguageProperty(IO type, String uriName, Class<?> classType, Object defaultValue) {
        this(type, uriName, new Class[]{classType}, defaultValue);
    }

    private X4OLanguageProperty(IO type, String uriName, Class<?>[] classTypes, Object defaultValue) {
        this.type = type;
        this.uriName = URI_PREFIX + uriName;
        this.classTypes = classTypes;
        this.defaultValue = defaultValue;
    }

    public final String toUri() {
        return this.uriName;
    }

    public final Object getDefaultValue() {
        return this.defaultValue;
    }

    public final boolean isValueValid(Object value) {
        if (LANGUAGE_NAME.equals((Object)this) | LANGUAGE_VERSION.equals((Object)this)) {
            return false;
        }
        if (value == null) {
            return true;
        }
        Class<?> valueClass = value.getClass();
        for (Class<?> c : this.classTypes) {
            if (!c.isAssignableFrom(valueClass)) continue;
            return true;
        }
        return false;
    }

    public static final X4OLanguageProperty valueByUri(String uri) {
        if (uri == null) {
            throw new NullPointerException("Can't search null uri.");
        }
        if (uri.length() == 0) {
            throw new IllegalArgumentException("Can't search empty uri.");
        }
        if (!uri.startsWith(URI_PREFIX)) {
            throw new IllegalArgumentException("Can't search for other name local prefix: http://language.x4o.org/xml/properties/ found: " + uri);
        }
        for (X4OLanguageProperty p : X4OLanguageProperty.values()) {
            if (!uri.equals(p.toUri())) continue;
            return p;
        }
        throw new IllegalArgumentException("Could not find language property for uri key: " + uri);
    }

    static {
        ArrayList<X4OLanguageProperty> readerResultKeys = new ArrayList<X4OLanguageProperty>();
        ArrayList<X4OLanguageProperty> writerResultKeys = new ArrayList<X4OLanguageProperty>();
        ArrayList<X4OLanguageProperty> schemaWriterResultKeys = new ArrayList<X4OLanguageProperty>();
        X4OLanguageProperty[] keys = X4OLanguageProperty.values();
        for (int i = 0; i < keys.length; ++i) {
            X4OLanguageProperty key = keys[i];
            if (IO.GLOBAL.equals((Object)key.type) || IO.READER.equals((Object)key.type) || IO.READER_WRITER.equals((Object)key.type)) {
                readerResultKeys.add(key);
            }
            if (IO.GLOBAL.equals((Object)key.type) || IO.WRITER.equals((Object)key.type) || IO.READER_WRITER.equals((Object)key.type)) {
                writerResultKeys.add(key);
            }
            if (!IO.GLOBAL.equals((Object)key.type) && !IO.SCHEMA_WRITER.equals((Object)key.type)) continue;
            schemaWriterResultKeys.add(key);
        }
        DEFAULT_X4O_READER_KEYS = readerResultKeys.toArray(new X4OLanguageProperty[readerResultKeys.size()]);
        DEFAULT_X4O_WRITER_KEYS = writerResultKeys.toArray(new X4OLanguageProperty[writerResultKeys.size()]);
        DEFAULT_X4O_SCHEMA_WRITER_KEYS = schemaWriterResultKeys.toArray(new X4OLanguageProperty[schemaWriterResultKeys.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum IO {
        GLOBAL,
        READER,
        WRITER,
        READER_WRITER,
        SCHEMA_WRITER;

    }
}

