/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.io.sax.ext;

import java.util.HashMap;
import java.util.Map;

public final class ContentConfig {
    private final ContentConfigItem[] items;
    private final Map<String, Integer> itemKeys;

    public ContentConfig(ContentConfigItem ... items) {
        this.items = items;
        this.itemKeys = new HashMap<String, Integer>(items.length);
        for (int i = 0; i < items.length; ++i) {
            ContentConfigItem item = items[i];
            this.itemKeys.put(item.getKey(), i);
        }
    }

    private final ContentConfigItem getContentConfigItem(String key) {
        Integer keyIdx = this.itemKeys.get(key);
        if (keyIdx == null) {
            throw new IllegalArgumentException("Could not find config item for: " + key);
        }
        ContentConfigItem item = this.items[keyIdx];
        return item;
    }

    public final void setProperty(String key, Object value) {
        ContentConfigItem item = this.getContentConfigItem(key);
        item.setValue(value);
    }

    public final Object getProperty(String key) {
        ContentConfigItem item = this.getContentConfigItem(key);
        return item.getValue();
    }

    public final boolean getPropertyBoolean(String key) {
        ContentConfigItem item = this.getContentConfigItem(key);
        Object value = item.getValue();
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return (Boolean)item.getDefaultValue();
    }

    public final int getPropertyInteger(String key) {
        ContentConfigItem item = this.getContentConfigItem(key);
        Object value = item.getValue();
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return (Integer)item.getDefaultValue();
    }

    public final String getPropertyString(String key) {
        ContentConfigItem item = this.getContentConfigItem(key);
        Object value = item.getValue();
        if (value instanceof String) {
            return (String)value;
        }
        return (String)item.getDefaultValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ContentConfigItem {
        private String key = null;
        private Class<?> valueType = null;
        private Object defaultValue = null;
        private Object value = null;

        public ContentConfigItem(String key, Class<?> valueType) {
            this(key, valueType, null);
        }

        public ContentConfigItem(String key, Class<?> valueType, Object defaultValue) {
            this.setKey(key);
            this.setValueType(valueType);
            this.setDefaultValue(defaultValue);
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Class<?> getValueType() {
            return this.valueType;
        }

        public void setValueType(Class<?> valueType) {
            this.valueType = valueType;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

