/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.io.sax;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.x4o.xml.element.ElementNamespaceContext;
import org.x4o.xml.lang.X4OLanguageClassLoader;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageModule;
import org.x4o.xml.lang.X4OLanguageProperty;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class X4OEntityResolver
implements EntityResolver {
    private Logger logger = null;
    private URL basePath = null;
    private X4OLanguageContext elementContext = null;
    private Map<String, String> schemaResources = null;
    private Map<String, String> schemaPathResources = null;

    public X4OEntityResolver(X4OLanguageContext elementContext) {
        if (elementContext == null) {
            throw new NullPointerException("Can't provide entities with null elementContext.");
        }
        this.logger = Logger.getLogger(X4OEntityResolver.class.getName());
        this.elementContext = elementContext;
        this.basePath = (URL)elementContext.getLanguageProperty(X4OLanguageProperty.READER_INPUT_BASE_PATH);
        this.schemaResources = new HashMap<String, String>(20);
        this.schemaPathResources = new HashMap<String, String>(20);
        for (X4OLanguageModule mod : elementContext.getLanguage().getLanguageModules()) {
            for (ElementNamespaceContext ns : mod.getElementNamespaceContexts()) {
                if (ns.getSchemaUri() == null || ns.getSchemaResource() == null) continue;
                StringBuffer buf = new StringBuffer(30);
                buf.append(elementContext.getLanguage().getLanguageConfiguration().getLanguageResourcePathPrefix());
                buf.append('/');
                buf.append(elementContext.getLanguage().getLanguageName());
                buf.append('/');
                buf.append(ns.getSchemaResource());
                this.schemaResources.put(ns.getSchemaUri(), buf.toString());
                buf = new StringBuffer(30);
                buf.append(elementContext.getLanguage().getLanguageName());
                buf.append(File.separatorChar);
                buf.append(ns.getSchemaResource());
                this.schemaPathResources.put(ns.getSchemaUri(), buf.toString());
            }
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        File schemaBasePath;
        InputSource result;
        this.logger.finer("Fetch sysId: " + systemId + " pubId: " + publicId);
        EntityResolver resolver = (EntityResolver)this.elementContext.getLanguageProperty(X4OLanguageProperty.READER_ENTITY_RESOLVER);
        if (resolver != null && (result = resolver.resolveEntity(publicId, systemId)) != null) {
            return result;
        }
        if (this.schemaPathResources.containsKey(systemId) && (schemaBasePath = (File)this.elementContext.getLanguageProperty(X4OLanguageProperty.READER_VALIDATION_SCHEMA_PATH)) != null && schemaBasePath.exists()) {
            String schemeResource = this.schemaResources.get(systemId);
            File schemaFile = new File(schemaBasePath.getAbsolutePath() + File.separatorChar + schemeResource);
            if (schemaFile.exists()) {
                if (!schemaFile.canRead()) {
                    throw new SAXException("Can't read schema file: " + schemaFile);
                }
                try {
                    InputSource in = new InputSource(new FileInputStream(schemaFile));
                    in.setPublicId(publicId);
                    in.setSystemId(systemId);
                    return in;
                }
                catch (IOException e) {
                    throw new SAXException("Could not open: " + schemaFile + " error: " + e.getMessage(), e);
                }
            }
        }
        if (this.schemaResources.containsKey(systemId)) {
            String schemeResource = this.schemaResources.get(systemId);
            ClassLoader cl = X4OLanguageClassLoader.getClassLoader();
            URL resource = cl.getResource(schemeResource);
            if (resource != null) {
                try {
                    InputSource in = new InputSource(resource.openStream());
                    in.setPublicId(publicId);
                    in.setSystemId(systemId);
                    return in;
                }
                catch (IOException e) {
                    throw new SAXException("Could not open: " + resource + " error: " + e.getMessage(), e);
                }
            }
        }
        if (this.basePath != null && systemId != null && systemId.startsWith(this.basePath.toExternalForm())) {
            this.logger.finer("Base reference basePath: " + this.basePath + " systemId: " + systemId);
            try {
                InputSource in = new InputSource(new URL(systemId).openStream());
                in.setPublicId(publicId);
                in.setSystemId(systemId);
                return in;
            }
            catch (IOException e) {
                throw new SAXException("Could not open: " + systemId + " error: " + e.getMessage(), e);
            }
        }
        throw new SAXException("SystemId not found: " + systemId);
    }
}

