/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.io;

public final class XMLConstants {
    public static final String XML = "xml";
    public static final String XML_DEFAULT_ENCODING = "UTF-8";
    public static final String XML_DEFAULT_VERSION = "1.0";
    public static final String XMLNS_ATTRIBUTE = "xmlns";
    public static final String XMLNS_ASSIGN = ":";
    public static final String XML_SCHEMA_NS_URI = "http://www.w3.org/2001/XMLSchema";
    public static final String XML_SCHEMA_INSTANCE_NS_URI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String NULL_NS_URI = "";
    public static final String XML_DOCTYPE = "<!DOCTYPE";
    public static final String TAG_OPEN = "<";
    public static final String TAG_OPEN_END = "</";
    public static final String TAG_CLOSE = ">";
    public static final String TAG_CLOSE_EMPTY = "/>";
    public static final String COMMENT_START = "<!--";
    public static final String COMMENT_END = "-->";
    public static final String PROCESS_START = "<?";
    public static final String PROCESS_END = "?>";
    public static final String CDATA_START = "<![CDATA[";
    public static final String CDATA_END = "]]>";
    public static final String CDATA_START_REGEX = "<!\\x" + Integer.toHexString(91) + "CDATA\\x" + Integer.toHexString(91);
    public static final String CDATA_END_REGEX = "\\x" + Integer.toHexString(93) + "\\x" + Integer.toHexString(93) + ">";
    public static final char CHAR_TAB = '\t';
    public static final char CHAR_NEWLINE = '\n';

    public static String getDocumentDeclaration(String encoding) {
        return XMLConstants.getDocumentDeclaration(encoding, null);
    }

    public static String getDocumentDeclaration(String encoding, String version) {
        if (encoding == null) {
            encoding = XML_DEFAULT_ENCODING;
        }
        if (version == null) {
            version = XML_DEFAULT_VERSION;
        }
        return String.format("<?xml version=\"%s\" encoding=\"%s\"?>", version, encoding);
    }

    public static boolean isChar(int c) {
        if (c >= 127 & c <= 132) {
            return false;
        }
        if (c >= 134 & c <= 159) {
            return false;
        }
        if (c >= 64976 & c <= 65007) {
            return false;
        }
        if (c >= 131070 & c <= 131071 || c >= 196606 & c <= 196607 | c >= 262142 & c <= 262143) {
            return false;
        }
        if (c >= 327678 & c <= 327679 || c >= 393214 & c <= 393215 | c >= 458750 & c <= 458751) {
            return false;
        }
        if (c >= 524286 & c <= 524287 || c >= 589822 & c <= 589823 | c >= 655358 & c <= 655359) {
            return false;
        }
        if (c >= 720894 & c <= 720895 || c >= 786430 & c <= 786431 | c >= 851966 & c <= 851967) {
            return false;
        }
        if (c >= 917502 & c <= 917503 || c >= 983038 & c <= 983039 | c >= 1048574 & c <= 1048575) {
            return false;
        }
        if (c >= 1114110 & c <= 0x10FFFF) {
            return false;
        }
        if (c == 9) {
            return true;
        }
        if (c == 10) {
            return true;
        }
        if (c == 13) {
            return true;
        }
        if (c >= 32 & c <= 55295) {
            return true;
        }
        if (c >= 57344 & c <= 65533) {
            return true;
        }
        return c >= 65536 & c <= 0x10FFFF;
    }

    public static boolean isNameStartChar(int c) {
        if (c >= 97 & c <= 122) {
            return true;
        }
        if (c >= 65 & c <= 90) {
            return true;
        }
        if (c == 58 || c == 95) {
            return true;
        }
        if (c >= 192 & c <= 214) {
            return true;
        }
        if (c >= 216 & c <= 246) {
            return true;
        }
        if (c >= 248 & c <= 767) {
            return true;
        }
        if (c >= 880 & c <= 893) {
            return true;
        }
        if (c >= 895 & c <= 8191) {
            return true;
        }
        if (c >= 8204 & c <= 8205) {
            return true;
        }
        if (c >= 8304 & c <= 8591) {
            return true;
        }
        if (c >= 11264 & c <= 12271) {
            return true;
        }
        if (c >= 12289 & c <= 55295) {
            return true;
        }
        if (c >= 63744 & c <= 64975) {
            return true;
        }
        if (c >= 65008 & c <= 65533) {
            return true;
        }
        return c >= 65536 & c <= 983039;
    }

    public static boolean isNameChar(int c) {
        if (XMLConstants.isNameStartChar(c)) {
            return true;
        }
        if (c == 45 || c == 46) {
            return true;
        }
        if (c >= 48 & c <= 57) {
            return true;
        }
        if (c == 183) {
            return true;
        }
        if (c >= 768 & c <= 879) {
            return true;
        }
        return c >= 8255 & c <= 8256;
    }

    public static boolean isCharString(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (XMLConstants.isNameChar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNameString(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (i == 0 && !XMLConstants.isNameStartChar(c)) {
                return false;
            }
            if (XMLConstants.isNameChar(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean escapeXMLValue(char c, StringBuffer result) {
        if (c == '<') {
            result.append("&lt;");
            return true;
        }
        if (c == '>') {
            result.append("&gt;");
            return true;
        }
        if (c == '&') {
            result.append("&amp;");
            return true;
        }
        if (c == '\"') {
            result.append("&quote;");
            return true;
        }
        if (c == '\'') {
            result.append("&apos;");
            return true;
        }
        return false;
    }

    public static String escapeAttributeName(String value) {
        int length = value.length();
        StringBuffer result = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (XMLConstants.isNameChar(c)) {
                result.append(c);
                continue;
            }
            result.append("#x");
            result.append(Integer.toHexString(c));
            result.append(";");
        }
        return result.toString();
    }

    public static String escapeAttributeValue(String value) {
        int length = value.length();
        StringBuffer result = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (XMLConstants.escapeXMLValue(c, result)) continue;
            result.append(c);
        }
        return result.toString();
    }

    public static String escapeCharacters(String value) {
        int length = value.length();
        StringBuffer result = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (XMLConstants.escapeXMLValue(c, result)) continue;
            result.append(c);
        }
        return result.toString();
    }

    public static String escapeCharactersCdata(String value, String replaceCdataStart, String replaceCdataEnd) {
        value = value.replaceAll(CDATA_START_REGEX, replaceCdataStart);
        value = value.replaceAll(CDATA_END_REGEX, replaceCdataEnd);
        return value;
    }

    public static String escapeCharactersComment(String value, String charTab, int indent) {
        value = value.replaceAll(COMMENT_START, NULL_NS_URI);
        value = value.replaceAll(COMMENT_END, NULL_NS_URI);
        int length = value.length();
        StringBuffer result = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c == '\n') {
                result.append(c);
                for (int ii = 0; ii < indent; ++ii) {
                    result.append(charTab);
                }
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }
}

