/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.eld.xsd;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.x4o.xml.eld.xsd.EldXsdXmlWriter;
import org.x4o.xml.element.ElementClass;
import org.x4o.xml.element.ElementException;
import org.x4o.xml.element.ElementNamespaceContext;
import org.x4o.xml.io.sax.ext.ContentWriterXsd;
import org.x4o.xml.lang.X4OLanguage;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageModule;
import org.x4o.xml.lang.X4OLanguageProperty;
import org.xml.sax.SAXException;

public class EldXsdXmlGenerator {
    private X4OLanguage language = null;
    private X4OLanguageContext languageContext = null;

    public EldXsdXmlGenerator(X4OLanguageContext languageContext) {
        this.languageContext = languageContext;
        this.language = languageContext.getLanguage();
    }

    private void checkNamespace(ElementNamespaceContext ns) {
        if (ns.getSchemaResource() == null) {
            throw new NullPointerException("Can't generate xsd for namespace without schemaResource uri: " + ns.getUri());
        }
        if (ns.getSchemaResource().length() == 0) {
            throw new NullPointerException("Can't generate xsd for namespace with empty schemaResource uri: " + ns.getUri());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSchema(String namespace) throws ElementException {
        File basePath = (File)this.languageContext.getLanguageProperty(X4OLanguageProperty.SCHEMA_WRITER_OUTPUT_PATH);
        String encoding = this.languageContext.getLanguagePropertyString(X4OLanguageProperty.SCHEMA_WRITER_OUTPUT_ENCODING);
        String charNew = this.languageContext.getLanguagePropertyString(X4OLanguageProperty.SCHEMA_WRITER_OUTPUT_CHAR_NEWLINE);
        String charTab = this.languageContext.getLanguagePropertyString(X4OLanguageProperty.SCHEMA_WRITER_OUTPUT_CHAR_TAB);
        if (basePath == null) {
            throw new ElementException("Can't write schema to null output path.");
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if (charNew == null) {
            charNew = "\n";
        }
        if (charTab == null) {
            charTab = "\t";
        }
        try {
            if (namespace != null) {
                ElementNamespaceContext ns = this.language.findElementNamespaceContext(namespace);
                if (ns == null) {
                    throw new NullPointerException("Could not find namespace: " + namespace);
                }
                this.checkNamespace(ns);
                File outputFile = new File(basePath.getAbsolutePath() + File.separatorChar + ns.getSchemaResource());
                OutputStreamWriter wr = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding);
                try {
                    ContentWriterXsd out = new ContentWriterXsd(wr, encoding, charNew, charTab);
                    this.generateSchema(ns.getUri(), out);
                }
                finally {
                    ((Writer)wr).close();
                }
                return;
            }
            for (X4OLanguageModule mod : this.language.getLanguageModules()) {
                for (ElementNamespaceContext ns : mod.getElementNamespaceContexts()) {
                    this.checkNamespace(ns);
                    File outputFile = new File(basePath.getAbsolutePath() + File.separatorChar + ns.getSchemaResource());
                    OutputStreamWriter wr = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding);
                    try {
                        ContentWriterXsd out = new ContentWriterXsd(wr, encoding, charNew, charTab);
                        this.generateSchema(ns.getUri(), out);
                    }
                    finally {
                        ((Writer)wr).close();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ElementException(e);
        }
    }

    public void generateSchema(String namespaceUri, ContentWriterXsd xmlWriter) throws SAXException {
        ElementNamespaceContext ns = this.language.findElementNamespaceContext(namespaceUri);
        if (ns == null) {
            throw new NullPointerException("Could not find namespace: " + namespaceUri);
        }
        EldXsdXmlWriter xsdWriter = new EldXsdXmlWriter(xmlWriter, this.language);
        xsdWriter.startNamespaces(namespaceUri);
        xsdWriter.startSchema(ns);
        for (ElementClass ec : ns.getElementClasses()) {
            xsdWriter.writeElementClass(ec, ns);
        }
        for (ElementClass ec : ns.getElementClasses()) {
            xsdWriter.writeElement(ec, ns);
        }
        xsdWriter.endSchema();
    }
}

