/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.eld;

import java.util.logging.Logger;
import org.x4o.xml.conv.ObjectConverter;
import org.x4o.xml.conv.text.ClassConverter;
import org.x4o.xml.eld.lang.AttributeAliasElement;
import org.x4o.xml.eld.lang.BeanElement;
import org.x4o.xml.eld.lang.DescriptionElement;
import org.x4o.xml.eld.lang.ElementClassAddParentElement;
import org.x4o.xml.eld.lang.ElementClassAttributeBindingHandler;
import org.x4o.xml.eld.lang.ElementClassBindingHandler;
import org.x4o.xml.eld.lang.ElementInterfaceBindingHandler;
import org.x4o.xml.eld.lang.ElementModuleBindingHandler;
import org.x4o.xml.eld.lang.ElementNamespaceContextBindingHandler;
import org.x4o.xml.eld.lang.ModuleElement;
import org.x4o.xml.element.ElementBindingHandler;
import org.x4o.xml.element.ElementClass;
import org.x4o.xml.element.ElementClassAttribute;
import org.x4o.xml.element.ElementNamespaceContext;
import org.x4o.xml.element.ElementNamespaceInstanceProvider;
import org.x4o.xml.element.ElementNamespaceInstanceProviderException;
import org.x4o.xml.lang.X4OLanguage;
import org.x4o.xml.lang.X4OLanguageClassLoader;
import org.x4o.xml.lang.X4OLanguageLocal;
import org.x4o.xml.lang.X4OLanguageModule;
import org.x4o.xml.lang.X4OLanguageModuleLoader;
import org.x4o.xml.lang.X4OLanguageModuleLoaderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EldModuleLoaderCore
implements X4OLanguageModuleLoader {
    private Logger logger = Logger.getLogger(EldModuleLoaderCore.class.getName());
    private static final String PP_CEL_PROVIDER_HOST = "cel.x4o.org";
    private static final String PP_CEL_XMLNS = "http://cel.x4o.org/xml/ns/";
    private static final String PP_CEL_XSD_FILE = "-1.0.xsd";
    private static final String CEL_CORE = "cel-core";
    private static final String CEL_ROOT = "cel-root";
    private static final String CEL_CORE_URI = "http://cel.x4o.org/xml/ns/cel-core";
    private static final String CEL_ROOT_URI = "http://cel.x4o.org/xml/ns/cel-root";
    private static final String CEL_CORE_XSD_URI = "http://cel.x4o.org/xml/ns/cel-core-1.0.xsd";
    private static final String CEL_ROOT_XSD_URI = "http://cel.x4o.org/xml/ns/cel-root-1.0.xsd";
    private static final String CEL_CORE_XSD_FILE = "cel-core-1.0.xsd";
    private static final String CEL_ROOT_XSD_FILE = "cel-root-1.0.xsd";

    @Override
    public void loadLanguageModule(X4OLanguageLocal language, X4OLanguageModule languageModule) throws X4OLanguageModuleLoaderException {
        this.configLanguageModule(languageModule);
        this.addBindingHandler(languageModule, new ElementClassBindingHandler(), "cel-class-bind", "Binds the ElementClass childeren.");
        this.addBindingHandler(languageModule, new ElementModuleBindingHandler(), "cel-module-bind", "Binds the LanguageModule childeren.");
        this.addBindingHandler(languageModule, new ElementClassAttributeBindingHandler(), "cel-class-attr-bind", "Binds the ElementClassAttribute childeren.");
        this.addBindingHandler(languageModule, new ElementInterfaceBindingHandler(), "cel-interface-bind", "Binds the ElementInterface childeren.");
        this.addBindingHandler(languageModule, new ElementNamespaceContextBindingHandler(), "cel-namespace-bind", "Binds the Namespace childeren.");
        ElementNamespaceContext namespace = this.createNamespaceContext(language, CEL_CORE, CEL_CORE_URI, CEL_CORE_XSD_URI, CEL_CORE_XSD_FILE, CEL_CORE);
        this.configElementClasses(language, namespace);
        this.startAndAddNamespace(language, languageModule, namespace);
        ElementNamespaceContext namespaceRoot = this.createNamespaceContext(language, CEL_ROOT, CEL_ROOT_URI, CEL_ROOT_XSD_URI, CEL_ROOT_XSD_FILE, CEL_ROOT);
        namespaceRoot.setLanguageRoot(true);
        ElementClass rootElement = this.createElementClass(language, "module", language.getLanguageConfiguration().getDefaultElementLanguageModule(), ModuleElement.class, "The module tag is the root xml element for ELD language.");
        rootElement.addElementClassAttribute(this.createElementClassAttribute(language, "id", true, null));
        rootElement.addElementClassAttribute(this.createElementClassAttribute(language, "providerHost", true, null));
        namespaceRoot.addElementClass(rootElement);
        this.startAndAddNamespace(language, languageModule, namespaceRoot);
    }

    private void configElementClasses(X4OLanguage language, ElementNamespaceContext namespace) throws X4OLanguageModuleLoaderException {
        ElementClass ec = null;
        namespace.addElementClass(this.createElementClass(language, "attribute", language.getLanguageConfiguration().getDefaultElementClassAttribute(), null, "Defines xml element attribute."));
        ec = this.createElementClass(language, "attributeAlias", null, AttributeAliasElement.class, "Adds an attribute alias.");
        ec.addElementClassAttribute(this.createElementClassAttribute(language, "name", true, null));
        ec.addElementParent(CEL_CORE_URI, "attribute");
        namespace.addElementClass(ec);
        namespace.addElementClass(this.createElementClass(language, "classConverter", ClassConverter.class, null, "Converts string attribute to java class instance."));
        ec = this.createElementClass(language, "namespace", language.getLanguageConfiguration().getDefaultElementNamespaceContext(), null, "Defines an xml namespace.");
        ec.addElementClassAttribute(this.createElementClassAttribute(language, "uri", true, null));
        namespace.addElementClass(ec);
        ec = this.createElementClass(language, "element", language.getLanguageConfiguration().getDefaultElementClass(), null, "Defines xml element tag.");
        ec.addElementClassAttribute(this.createElementClassAttribute(language, "objectClass", false, new ClassConverter()));
        ec.addElementClassAttribute(this.createElementClassAttribute(language, "elementClass", false, new ClassConverter()));
        namespace.addElementClass(ec);
        ec = this.createElementClass(language, "elementInterface", language.getLanguageConfiguration().getDefaultElementInterface(), null, "Defines element interface class.");
        ec.addElementClassAttribute(this.createElementClassAttribute(language, "interfaceClass", false, new ClassConverter()));
        namespace.addElementClass(ec);
        ec = this.createElementClass(language, "bindingHandler", null, BeanElement.class, "Defines generic binding handler for languge.");
        ec.addElementParent(CEL_ROOT_URI, "module");
        ec.addElementParent(CEL_CORE_URI, "elementInterface");
        ec.addElementClassAttribute(this.createElementClassAttribute(language, "id", true, null));
        ec.addElementClassAttribute(this.createElementClassAttribute(language, "bean.class", true, null));
        namespace.addElementClass(ec);
        ec = this.createElementClass(language, "attributeHandler", null, BeanElement.class, "Defines generic attribute handler for language.");
        ec.addElementParent(CEL_ROOT_URI, "module");
        ec.addElementClassAttribute(this.createElementClassAttribute(language, "bean.class", true, null));
        namespace.addElementClass(ec);
        ec = this.createElementClass(language, "configurator", null, BeanElement.class, "Define generic configurator for language.");
        ec.addElementParent(CEL_CORE_URI, "elementInterface");
        ec.addElementParent(CEL_CORE_URI, "element");
        ec.addElementClassAttribute(this.createElementClassAttribute(language, "bean.class", true, null));
        ec.addElementClassAttribute(this.createElementClassAttribute(language, "configAction", false, null));
        namespace.addElementClass(ec);
        ec = this.createElementClass(language, "configuratorGlobal", null, BeanElement.class, "Define generic global configuator for languge.");
        ec.addElementParent(CEL_ROOT_URI, "module");
        ec.addElementClassAttribute(this.createElementClassAttribute(language, "bean.class", true, null));
        ec.addElementClassAttribute(this.createElementClassAttribute(language, "configAction", false, null));
        namespace.addElementClass(ec);
        ec = this.createElementClass(language, "description", null, DescriptionElement.class, "Adds description as text on all eld elements.");
        ec.setSchemaContentBase("string");
        ec.addElementParent(CEL_ROOT_URI, "module");
        ec.addElementParent(CEL_CORE_URI, "namespace");
        ec.addElementParent(CEL_CORE_URI, "attributeHandler");
        ec.addElementParent(CEL_CORE_URI, "bindingHandler");
        ec.addElementParent(CEL_CORE_URI, "configurator");
        ec.addElementParent(CEL_CORE_URI, "configuratorGlobal");
        ec.addElementParent(CEL_CORE_URI, "elementInterface");
        ec.addElementParent(CEL_CORE_URI, "element");
        ec.addElementParent(CEL_CORE_URI, "attribute");
        namespace.addElementClass(ec);
        ec = this.createElementClass(language, "elementParent", null, ElementClassAddParentElement.class, "Added (meta) element parent.");
        ec.addElementParent(CEL_CORE_URI, "element");
        ec.addElementParent(CEL_CORE_URI, "elementInterface");
        ec.addElementClassAttribute(this.createElementClassAttribute(language, "tag", true, null));
        ec.addElementClassAttribute(this.createElementClassAttribute(language, "uri", false, null));
        namespace.addElementClass(ec);
    }

    private void configLanguageModule(X4OLanguageModule languageModule) {
        languageModule.setId("cel-module");
        languageModule.setProviderName("Core Element Languag Module");
        languageModule.setProviderHost(PP_CEL_PROVIDER_HOST);
        languageModule.setDescription("Core Element Language Module Loader");
        languageModule.setSourceResource(this.getClass().getSimpleName());
    }

    private void startAndAddNamespace(X4OLanguageLocal language, X4OLanguageModule languageModule, ElementNamespaceContext namespace) throws X4OLanguageModuleLoaderException {
        try {
            namespace.getElementNamespaceInstanceProvider().start(language, namespace);
        }
        catch (ElementNamespaceInstanceProviderException e) {
            throw new X4OLanguageModuleLoaderException(this, "Error starting instance provider: " + e.getMessage(), e);
        }
        languageModule.addElementNamespaceContext(namespace);
    }

    private ElementNamespaceContext createNamespaceContext(X4OLanguageLocal language, String id, String uri, String schemaUri, String schemaResource, String schemaPrefix) throws X4OLanguageModuleLoaderException {
        ElementNamespaceContext namespace;
        this.logger.finer("Creating " + language.getLanguageName() + " namespace.");
        try {
            namespace = (ElementNamespaceContext)X4OLanguageClassLoader.newInstance(language.getLanguageConfiguration().getDefaultElementNamespaceContext());
        }
        catch (InstantiationException e) {
            throw new X4OLanguageModuleLoaderException(this, e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new X4OLanguageModuleLoaderException(this, e.getMessage(), e);
        }
        try {
            namespace.setElementNamespaceInstanceProvider((ElementNamespaceInstanceProvider)X4OLanguageClassLoader.newInstance(language.getLanguageConfiguration().getDefaultElementNamespaceInstanceProvider()));
        }
        catch (InstantiationException e) {
            throw new X4OLanguageModuleLoaderException(this, e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new X4OLanguageModuleLoaderException(this, e.getMessage(), e);
        }
        namespace.setId(id);
        namespace.setUri(uri);
        namespace.setSchemaUri(schemaUri);
        namespace.setSchemaResource(schemaResource);
        namespace.setSchemaPrefix(schemaPrefix);
        return namespace;
    }

    private ElementClass createElementClass(X4OLanguage language, String tag, Class<?> objectClass, Class<?> elementClass, String description) throws X4OLanguageModuleLoaderException {
        try {
            ElementClass result = (ElementClass)X4OLanguageClassLoader.newInstance(language.getLanguageConfiguration().getDefaultElementClass());
            result.setId(tag);
            result.setObjectClass(objectClass);
            result.setElementClass(elementClass);
            result.setDescription(description);
            return result;
        }
        catch (InstantiationException e) {
            throw new X4OLanguageModuleLoaderException(this, e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new X4OLanguageModuleLoaderException(this, e.getMessage(), e);
        }
    }

    private ElementClassAttribute createElementClassAttribute(X4OLanguage language, String name, boolean required, ObjectConverter converter) throws X4OLanguageModuleLoaderException {
        try {
            ElementClassAttribute result = (ElementClassAttribute)X4OLanguageClassLoader.newInstance(language.getLanguageConfiguration().getDefaultElementClassAttribute());
            result.setId(name);
            if (required) {
                result.setRequired(required);
            }
            if (converter != null) {
                result.setObjectConverter(converter);
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new X4OLanguageModuleLoaderException(this, e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new X4OLanguageModuleLoaderException(this, e.getMessage(), e);
        }
    }

    private void addBindingHandler(X4OLanguageModule languageModule, ElementBindingHandler handler, String id, String description) {
        handler.setId(id);
        handler.setDescription(description);
        languageModule.addElementBindingHandler(handler);
    }
}

