/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.eld;

import java.io.IOException;
import java.util.logging.Logger;
import org.x4o.xml.X4ODriver;
import org.x4o.xml.X4ODriverManager;
import org.x4o.xml.io.DefaultX4OReader;
import org.x4o.xml.io.X4OConnectionException;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageLocal;
import org.x4o.xml.lang.X4OLanguageModule;
import org.x4o.xml.lang.X4OLanguageModuleLoader;
import org.x4o.xml.lang.X4OLanguageModuleLoaderException;
import org.xml.sax.SAXException;

public class EldModuleLoader
implements X4OLanguageModuleLoader {
    private Logger logger = null;
    private String eldResource = null;
    private boolean isEldCore = false;
    public static final String EL_PARENT_LANGUAGE_CONFIGURATION = "parentLanguageConfiguration";
    public static final String EL_PARENT_ELEMENT_LANGUAGE_MODULE = "parentElementLanguageModule";
    public static final String EL_PARENT_LANGUAGE = "parentLanguage";

    public EldModuleLoader(String eldResource, boolean isEldCore) {
        if (eldResource == null) {
            throw new NullPointerException("Can't load null eld resource.");
        }
        this.logger = Logger.getLogger(EldModuleLoader.class.getName());
        this.eldResource = eldResource;
        this.isEldCore = isEldCore;
    }

    public void loadLanguageModule(X4OLanguageLocal language, X4OLanguageModule elementLanguageModule) throws X4OLanguageModuleLoaderException {
        this.logger.fine("Loading name eld file from resource: " + this.eldResource);
        try {
            X4ODriver<?> driver = null;
            driver = this.isEldCore ? X4ODriverManager.getX4ODriver("cel") : X4ODriverManager.getX4ODriver("eld");
            X4OLanguageContext eldLang = driver.createLanguageContext(driver.getLanguageVersionDefault());
            DefaultX4OReader reader = new DefaultX4OReader(eldLang);
            reader.addELBeanInstance(EL_PARENT_LANGUAGE_CONFIGURATION, language.getLanguageConfiguration());
            reader.addELBeanInstance(EL_PARENT_LANGUAGE, language);
            reader.addELBeanInstance(EL_PARENT_ELEMENT_LANGUAGE_MODULE, elementLanguageModule);
            reader.readResource(this.eldResource);
        }
        catch (X4OConnectionException e) {
            throw new X4OLanguageModuleLoaderException(this, e.getMessage() + " while parsing: " + this.eldResource, e);
        }
        catch (SAXException e) {
            throw new X4OLanguageModuleLoaderException(this, e.getMessage() + " while parsing: " + this.eldResource, e);
        }
        catch (IOException e) {
            throw new X4OLanguageModuleLoaderException(this, e.getMessage() + " while parsing: " + this.eldResource, e);
        }
    }
}

