/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.el;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.el.FunctionMapper;

public class X4OELFunctionMapper
extends FunctionMapper {
    private Map<String, Method> functionMap = new HashMap<String, Method>(50);

    public Method resolveFunction(String prefix, String localName) {
        String key = prefix + ":" + localName;
        return this.functionMap.get(key);
    }

    public void addFunction(String prefix, String localName, Method method) {
        if (prefix == null || localName == null || method == null) {
            throw new NullPointerException();
        }
        int modifiers = method.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            throw new IllegalArgumentException("method not public");
        }
        if (!Modifier.isStatic(modifiers)) {
            throw new IllegalArgumentException("method not static");
        }
        Class<?> retType = method.getReturnType();
        if (retType == Void.TYPE) {
            throw new IllegalArgumentException("method returns void");
        }
        String key = prefix + ":" + localName;
        this.functionMap.put(key, method);
    }
}

