/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.io;

import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import junit.framework.TestCase;
import org.x4o.xml.io.X4OReader;
import org.x4o.xml.io.X4OWriter;
import org.x4o.xml.test.TestDriver;
import org.x4o.xml.test.models.TestObjectRoot;

public class X4OWriterAttributeTest
extends TestCase {
    private File createOutputFile() throws IOException {
        File outputFile = File.createTempFile("test-writer-attr", ".xml");
        outputFile.deleteOnExit();
        return outputFile;
    }

    public void testWriteAttrNatural() throws Exception {
        File outputFile = this.createOutputFile();
        TestDriver driver = TestDriver.getInstance();
        X4OReader reader = driver.createReader();
        X4OWriter writer = driver.createWriter();
        TestObjectRoot root = (TestObjectRoot)reader.readResource("tests/writer/test-attribute-order.xml");
        writer.writeFile((Object)root, outputFile);
        String text = new Scanner(outputFile).useDelimiter("\\A").next();
        outputFile.delete();
        X4OWriterAttributeTest.assertTrue((boolean)text.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
        X4OWriterAttributeTest.assertTrue((boolean)text.contains("TestAttributeOrderChildNatural aaaName=\"NAME_1\" aabName=\"NAME_2\" aacName=\"NAME_3\" abaName=\"NAME_4\" abbName=\"NAME_5\" abcName=\"NAME_6\" caaName=\"NAME_7\" cabName=\"NAME_8\" cacName=\"NAME_9\""));
    }

    public void testWriteAttrOrdered() throws Exception {
        File outputFile = this.createOutputFile();
        TestDriver driver = TestDriver.getInstance();
        X4OReader reader = driver.createReader();
        X4OWriter writer = driver.createWriter();
        TestObjectRoot root = (TestObjectRoot)reader.readResource("tests/writer/test-attribute-order.xml");
        writer.writeFile((Object)root, outputFile);
        String text = new Scanner(outputFile).useDelimiter("\\A").next();
        outputFile.delete();
        X4OWriterAttributeTest.assertTrue((boolean)text.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
        X4OWriterAttributeTest.assertTrue((boolean)text.contains("custom-ordered-child cacName=\"NAME_9\" cabName=\"NAME_8\" caaName=\"NAME_7\" abcName=\"NAME_6\" abbName=\"NAME_5\" abaName=\"NAME_4\" aaaName=\"NAME_1\" aabName=\"NAME_2\" aacName=\"NAME_3\""));
    }
}

