//  $Id: energiebar.cxx,v 1.3 2003/11/05 12:41:37 grumbel Exp $
//
//  Pingus - A free Lemmings clone
//  Copyright (C) 2002 Ingo Ruhnke <grumbel@gmx.de>
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#include <ClanLib/Display/color.h>
#include <ClanLib/Display/display.h>
#include <ClanLib/Display/display_window.h>
#include <ClanLib/Display/graphic_context.h>
#include "globals.hxx"
#include "player.hxx"
#include "energiebar.hxx"

Energiebar::Energiebar()
  : bar("energiebar", resources)
{
}

Energiebar::~Energiebar()
{
}
  
void
Energiebar::draw()
{
  int energie     = Player::current()->get_energie();
  int max_energie = Player::current()->get_max_energie();

  for(int i = 0; i < energie; ++i)
    {
      float red   = 1.0f;
      float green = (i/float(max_energie));
      CL_Sprite sprite = bar;
      sprite.set_color(red, green, 0, 1.0f);
      sprite.draw(15 + (i * 10), 15);
      CL_Display::get_current_window()->get_gc()->flush();
    }

  for(int i = energie; i < max_energie; ++i)
    {
      bar.set_color(.5f, .5f, .5f, .5f);
      bar.draw(15 + (i * 10), 15);
    }
}

void
Energiebar::update(float delta)
{
  bar.update(delta);
}

/* EOF */
