#!/usr/bin/env python

"""Logs Out a user
"""
copyright = """
Copyright (C) 2003 Jaime Villate <villate@gnu.org>
 """
license = """
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
"""

import re, time
from wikiup import Config, PrintPage, GetUsername, MakeCookie, ReadCookie

def RemoveHash(username):
    """Removes a pair username:hash from the login file
       For each user who is logged in, there should be a line in the
       login file with a pair username:hash.
    """ 
    filename = Config('account','login_file')
    login = open(filename,'r')
    content = login.read()
    login.close()
    content = re.compile(username+r':.*?\n').sub('',content)
    login = open(filename,'w')
    login.write(content)
    login.close()
    return

# Text messages
#
alreadyout = """
<p>You were not logged in this server. It was not necessary to log you out.</p>
"""
loggedout = """
<p>You have been logged out from your <b>%s</b> account in this
server.</p>
"""

# Variable's initial values
#
page = Config('dynamic','template')
cookie = ''
isloggedin = 0
username = ''

# Main module

hash = ReadCookie('session')
if hash:
   username = GetUsername(hash)
   if username:
      isloggedin = 1
if isloggedin:
   expTime = time.gmtime(time.time()-31536000)
   expStr = time.strftime('%A, %d-%b-%Y %T GMT', expTime)
   home = Config('dynamic','home_path')
   cookie = MakeCookie(session=hash, path=home, expires=expStr)
   RemoveHash(username)
   text = loggedout % username
   title = 'Log out successful'
   username = ''
else:
   title = 'Already logged out'
   text = alreadyout
if not username: username = 'Unknown'
PrintPage(title, text, page, username, cookie)

