#!/usr/bin/env python

"""User Login interface

   Each line in passwd_file has:
   Login name:encrypted password:user ID:group ID:name and e-mail
"""
copyright = """
Copyright (C) 2003 Jaime Villate <villate@gnu.org>
 """
license = """
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
"""

import os, re, cgi, time
from random import random
from wikiup import MD5sum, MD5sumCheck, Config, PrintPage, UserInfo, \
                     GetUsername, MakeCookie, ReadCookie

def SaveHash(username, hash):
    """Appends a pair username:hash to the login file
       Users who have logged in sucessfully, will receive a cookie with
       some random hash. When a cookie is received, the hash will be looked
       up in the login file and the username will be obtained from it.
    """ 
    filename = Config('account','login_file')
    login = open(filename,'r')
    content = login.read()
    login.close()
    content = re.compile(username+r':.*?\n').sub('',content)
    content += username + ':' + hash + '\n'
    login = open(filename,'w')
    login.write(content)
    login.close()
    return

# Text messages
#
form = """
<form action="login.py" method="post">
<table>		
<tr><td><b>Username:</b></td>
<td><input type="text" name="username" size="15" maxlength="15"></td></tr>
<tr><td><b>Password:</b></td>
<td><input type="password" name="passwd" size="12" maxlength="12"></td></tr>
<tr><td colspan="2"><input type="submit" value="Log in"></td></tr>
</table></form>
<p>This server requires a browser with cookies support enabled.</p>
"""
alreadyin = """
<p><font color="#ff0000">You are already logged in this server as <b>%s</b>
If you'd like to log in as a different user, you should first log out.
</font></p>
"""
wrongpasswd = """
<p><font color="#ff0000">Wrong password. Try it again.</font></p>
"""
loggedin = """
<p>You have successfully  logged into this server. You will remain logged in
for a year, unless you use the log out option.</p>
"""
intro = """
<p>Please fill in your username and password. If you do not have a
username/password yet, you will have to register first.
"""

# Variable's initial values
#
page = Config('dynamic','template')
cookie = ''
isloggedin = 0
username = ''

# Main module

hash = ReadCookie('session')
if hash:
   username = GetUsername(hash)
   if username:
      isloggedin = 1
if isloggedin:
   title = 'Already logged in'
   text = alreadyin % username
else:
   login = 0
   formStorage = cgi.FieldStorage()
   if formStorage.has_key('username') and formStorage.has_key('passwd'):
      username = formStorage['username'].value
      password = formStorage['passwd'].value
      if MD5sumCheck(password, UserInfo(username,'passwd')):
	 login = 1
      else:
         message = wrongpasswd
   if login:
      hash = MD5sum(username + '%s' % random())
      expTime = time.gmtime(time.time()+31536000)
      expStr = time.strftime('%A, %d-%b-%Y %T GMT', expTime)
      home = Config('dynamic','home_path')
      cookie = MakeCookie(session=hash, path=home, expires=expStr)
      SaveHash(username, hash)
      text = loggedin
      title = 'Log in successful'
   else:
      try:
         text = message
      except:
         text = intro
      text += form
      title = 'Log In'
      username = ''
if not username: username = 'Unknown'
PrintPage(title, text, page, username, cookie)

